package com.elitesland.tw.tw5.api.prd.acc.vo;

import com.elitescloud.boot.common.param.BaseViewModel;
import com.elitesland.tw.tw5.api.udc.UdcName;
import io.swagger.annotations.ApiModelProperty;
import lombok.Getter;
import lombok.Setter;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.List;


/**
  * 报销逾期配置
  *
  * @author zoey
  * @date 2024-04-08
  */
@Getter
@Setter
public class AccReimSettingOverdueVO extends BaseViewModel implements Serializable {

    /** 逾期开始日期 */
    @ApiModelProperty("逾期开始日期")
    private String overdueStartDate;

    /** 逾期开始日期 */
    @ApiModelProperty("逾期开始日期")
    @UdcName(udcName = "ACC:OVERDUE_START_DATE", codePropName = "overdueStartDate")
    private String overdueStartDateDesc;

    /**
     * 配置主表
     */
    private AccReimSettingVO accReimSettingVO;

    /**
     * 打折明细表
     */
    private List<AccReimSettingOverdueDiscuntVO> accReimSettingOverdueDiscuntVOList;

    /** 折扣（0~10） */
    @ApiModelProperty("折扣（0~10）")
    private BigDecimal invLimit;

}
