package com.elitesland.tw.tw5.api.prd.cal.vo;

import com.elitescloud.boot.common.param.BaseViewModel;
import com.elitesland.tw.tw5.api.udc.UdcName;
import io.swagger.annotations.ApiModelProperty;
import lombok.Getter;
import lombok.Setter;
import lombok.ToString;

import java.io.Serializable;
import java.math.BigDecimal;


/**
 * 核算-账号功能管理
 *
 * @author carl
 * @date 2023-11-13
 */
@Getter
@Setter
@ToString
public class CalAccountVO extends BaseViewModel implements Serializable {
    /**
     * 账号年度
     */
    @ApiModelProperty("账号年度")
    private Integer ledgerYear;
    /**
     * 账户名称
     */
    @ApiModelProperty("账户名称")
    private String ledgerName;
    /**
     * 账户状态(1有效 0无效)
     */
    @ApiModelProperty("账户状态(1有效 0无效)")
    private Integer ledgerStatus;
    /**
     * （账户类型）核算主体类型
     */
    @ApiModelProperty("（账户类型）核算主体类型")
    private String auType;
    @UdcName(udcName = "CAL:ACC:TYPE", codePropName = "auType")
    private String auTypeDesc;

    /**
     * 核算主体id
     */
    @ApiModelProperty("核算主体id")
    private Long auId;
    /**
     * 账号编号
     */
    @ApiModelProperty("账号编号")
    private String ledgerNo;
    //1：平台账户，0：否
    private String ledgerType;
    /**
     * 币种
     */
    @ApiModelProperty("币种")
    private String currCode;
    /**
     * 总数量
     */
    @ApiModelProperty("总数量")
    private BigDecimal totalQty;
    /**
     * 总金额
     */
    @ApiModelProperty("总金额")
    private BigDecimal totalAmt;

    /**
     * 可用数量
     */
    @ApiModelProperty("可用数量")
    private BigDecimal avalQty;
    /**
     * 可用金额
     */
    @ApiModelProperty("可用金额")
    private BigDecimal avalAmt;
    /**
     * 冻结数量
     */
    @ApiModelProperty("冻结数量")
    private BigDecimal frozenQty;
    /**
     * 冻结金额
     */
    @ApiModelProperty("冻结金额")
    private BigDecimal frozenAmt;

}
