package com.elitesland.tw.tw5.api.prd.crm.payload;

import com.elitesland.tw.tw5.api.common.TwCommonPayload;
import io.swagger.annotations.ApiModelProperty;
import lombok.Getter;
import lombok.Setter;
import org.springframework.format.annotation.DateTimeFormat;

import java.io.Serializable;
import java.time.LocalDate;

/**
 * 里程碑计划
 *
 * @author zoey
 * @date 2023-11-01
 */
@Getter
@Setter
public class CrmOpportunityMilestonePlanPayload extends TwCommonPayload  implements Serializable {
    /** 商机id */
    @ApiModelProperty("商机id")
    private Long oppoId;
    /** 关键里程碑 */
    @ApiModelProperty("关键里程碑")
    private String milestone;
    /** 负责人 */
    @ApiModelProperty("负责人")
    private String directorUserId;
    /** 状态 */
    @ApiModelProperty("状态")
    private String state;
    /** 开始时间 */
    @ApiModelProperty("开始时间")
    @DateTimeFormat(pattern = "yyyy-MM-dd")
    private LocalDate dateFrom;
    /** 结束时间 */
    @ApiModelProperty("结束时间")
    @DateTimeFormat(pattern = "yyyy-MM-dd")
    private LocalDate dateTo;
}
