package com.elitesland.tw.tw5.api.prd.crm.service;


import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.tw.tw5.api.prd.crm.payload.CrmOpportunityReviewPayload;
import com.elitesland.tw.tw5.api.prd.crm.query.CrmOpportunityReviewQuery;
import com.elitesland.tw.tw5.api.prd.crm.vo.CrmOpportunityReviewVO;

import javax.servlet.http.HttpServletResponse;
import java.util.List;

/**
 * 商机review
 *
 * @author zoey
 * @date 2023-11-01
 */
public interface CrmOpportunityReviewService {

    /**
     * 分页列表
     *
     * @param query 条件
     * @return {@link PagingVO}<{@link CrmOpportunityReviewVO}>
     */
    PagingVO<CrmOpportunityReviewVO> queryPaging(CrmOpportunityReviewQuery query);

    /**
     * 查询列表
     *
     * @param query 条件参数
     * @return {@link List}<{@link CrmOpportunityReviewVO}>
     */
    List<CrmOpportunityReviewVO> queryListDynamic(CrmOpportunityReviewQuery query);

    /**
     * 通过主键查询
     *
     * @param key 主键
     * @return {@link CrmOpportunityReviewVO}
     */
    CrmOpportunityReviewVO queryByKey(Long key);

    /**
     * 新增
     *
     * @param payload 单据数据
     * @return {@link CrmOpportunityReviewVO}
     */
    CrmOpportunityReviewVO insert(CrmOpportunityReviewPayload payload);

    /**
     * 修改
     *
     * @param payload 单据数据
     * @return {@link CrmOpportunityReviewVO}
     */
    CrmOpportunityReviewVO update(CrmOpportunityReviewPayload payload);

    /**
     * 修改,置空的字段需需要借助 protected List<String> nullFields;
     *
     * @param payload 单据数据
     * @return {@link long}
     */
    long updateByKeyDynamic(CrmOpportunityReviewPayload payload);

    /**
     * 逻辑删除
     *
     * @param keys 主键集合
     */
    void deleteSoft(List<Long> keys);

}
