package com.elitesland.tw.tw5.api.prd.my.query;

import com.elitesland.tw.tw5.api.common.TwQueryParam;
import com.elitesland.tw.tw5.api.udc.UdcName;
import com.elitesland.workflow.enums.ProcInstStatus;
import io.swagger.annotations.ApiModelProperty;
import lombok.Getter;
import lombok.Setter;
import java.io.Serializable;
    import java.time.LocalDate;
    import java.time.LocalDateTime;
import java.util.List;

/**
 * 用印申请
 *
 * @author wangly
 * @date 2023-09-14
 */
@Getter
@Setter
public class TBusiSignetApplyQuery extends TwQueryParam implements Serializable{
    /** 记录唯一ID 精确 */
    @ApiModelProperty("记录唯一ID")
    private Long id;
    /** BaseBU 精确 */
    @ApiModelProperty("BaseBU")
    private Long basebuId;
    /** 所属公司 精确 */
    @ApiModelProperty("所属公司")
    private Long ouId;
    /** 联系电话 精确 */
    @ApiModelProperty("联系电话")
    private String phone;
    /** 邮箱 精确 */
    @ApiModelProperty("邮箱")
    private String email;
    /** 印章场景 */
    @ApiModelProperty("印章场景")
    private String signetScene;
    /** 是否需要打印 */
    @ApiModelProperty("是否需要打印 1是0否")
    private Boolean printFlag;
    /** 印章类型 */
    @ApiModelProperty("印章类型")
    private String signetType;
    /** 相关印章 */
    @ApiModelProperty("相关印章")
    private String relatedSignet;
    /** 印章所属公司 */
    @ApiModelProperty("印章所属公司")
    private String signetBelongCompany;
    /** 印章用途 精确 */
    @ApiModelProperty("印章用途")
    private String signetPurpose;
    /** 申请印章 精确 */
    @ApiModelProperty("申请印章")
    private String signetApply;
    /** 是否外借 精确 */
    @ApiModelProperty("是否外借")
    private Boolean lendFlag;
    /** 附件 精确 */
    @ApiModelProperty("附件")
    private String fileCode;
    /** 印章归还说明 精确 */
    @ApiModelProperty("印章归还说明")
    private String signetReturnRemark;
    /** 申请人 精确 */
    @ApiModelProperty("申请人")
    private Long applyResId;
    /** 申请日期 精确 */
    @ApiModelProperty("申请日期")
    private LocalDate applyDate;
    /** 流程实例ID 精确 */
    @ApiModelProperty("流程实例ID")
    private String procInstId;
    /** 流程审批状态 精确 */
    @ApiModelProperty("流程审批状态")
    private ProcInstStatus procInstStatus;
    /** 提交时间 精确 */
    @ApiModelProperty("提交时间")
    private LocalDateTime submitTime;
    /** 审批时间 精确 */
    @ApiModelProperty("审批时间")
    private LocalDateTime approvedTime;
    /** 预计归还时间 精确 */
    @ApiModelProperty("预计归还时间")
    private LocalDate predictReturnTime;
    /** 扩展字段1 精确 */
    @ApiModelProperty("扩展字段1")
    private String ext1;
    /** 扩展字段2 精确 */
    @ApiModelProperty("扩展字段2")
    private String ext2;
    /** 扩展字段3 精确 */
    @ApiModelProperty("扩展字段3")
    private String ext3;
    /** 扩展字段4 精确 */
    @ApiModelProperty("扩展字段4")
    private String ext4;
    /** 扩展字段5 精确 */
    @ApiModelProperty("扩展字段5")
    private String ext5;
    /** 排序号 精确 */
    @ApiModelProperty("排序号")
    private Integer sortNo;
}
