package com.elitesland.tw.tw5.api.prd.partner.common.vo;

import com.elitescloud.boot.common.param.BaseViewModel;
import lombok.Getter;
import lombok.Setter;

import java.io.Serializable;

/**
 * 业务伙伴管理-主档数据同步
 *
 * @author wangluyu
 * @date 2023-11/25
 */
@Getter
@Setter
public class BusinessPartnerMainSyncVO extends BaseViewModel implements Serializable {
    /**
     * 4.0的客户id 猜测是要和之前4.0初始化到5.0数据的客户id保持一致 避免查询不到数据
     */
    private Long id;

    /**
     * 地址簿id
     */
    private Long bookId;
    /**
     * 4.0地址簿id
     */
    private Long bookIdV4;
    /**
     * 地址簿编号
     */
    private String bookNo;
    /**
     * 客户状态(激活，暂挂)  需翻译
     */
    private String customerStatus;
    /**
     * 客户名称
     */
    private String customerName;
    /**
     * 客户级别
     */
    private String customerGrade;

    /**
     * 客户来源 4.0没有
     */
    private String customerSource;
    /**
     * 客户行业 udc相同无需翻译
     */
    private String companyIndustry;

    /**
     * 电话
     */
    private String companyPhone;

    /**
     * 邮箱
     */
    private String companyEmail;

    /**
     * 传真
     */
    private String companyFax;
    /**
     * 省 省市区由4.0翻译
     */
    private String province;
    /**
     * 省
     */
    private String provinceName;
    /**
     * 市
     */
    private String city;
    /**
     * 市
     */
    private String cityName;
    /**
     * 区
     */
    private String district;
    /**
     * 区
     */
    private String districtName;
    /**
     * 详细地址
     */
    private String companyAddress;

    /**
     * 网址
     */
    private String companyWebsite;
    /**
     * 规模 需翻译
     */
    private String companyScale;
    /**
     * 税号
     */
    private String taxNo;
    /**
     * 交易货币
     */
    private String currency;
    /**
     * 语言
     */
    private String language;
    /**
     * 公司性质 udc相同无需翻译
     */
    private String companyNature;

    /**
     * 服务负责人
     */
    private Long serviceUserId;
    /**
     * 商务负责人
     */
    private Long businessUserId;

    /**
     * 关怀负责人
     */
    private Long careUserId;

    /**
     * 运维售后负责人
     */
    private Long operationUserId;

    /**
     * 备注
     */
    private String remark;

    /**
     * 地址簿数据类型（01 客户 02 供应商）
     */
    private String relateType;

    /**
     * 地址簿类型（01 个人 02 公司 03 bu）
     */
    private String abType;

    /**
     * 内部外部
     */
    private String innerType;
}
