package com.elitesland.tw.tw5.api.prd.pms.service;


import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.tw.tw5.api.prd.pms.payload.PmsProjectConclusionPayload;
import com.elitesland.tw.tw5.api.prd.pms.query.PmsProjectConclusionQuery;
import com.elitesland.tw.tw5.api.prd.pms.vo.PmsInspectionItemConfigVO;
import com.elitesland.tw.tw5.api.prd.pms.vo.PmsProjectConclusionVO;
import com.elitesland.workflow.payload.ProcessStatusChangePayload;
import com.elitesland.workflow.payload.TaskCreatedPayload;

import java.util.List;

/**
 * 项目结项
 *
 * @author xxb
 * @date 2023-11-27
 */
public interface PmsProjectConclusionService {


    /**
     * 根据项目id查询项目结项
     * * @return
     */
    PmsProjectConclusionVO queryByProjectId(Long projectId);

    /**
     * 项目结项-新增/更新
     *
     * @param payload 单据数据
     * @return {@link PmsProjectConclusionVO}
     */
    void insertOrUpdate(PmsProjectConclusionPayload payload);

    /**
     * 分页列表
     *
     * @param query 条件
     * @return {@link PagingVO}<{@link PmsProjectConclusionVO}>
     */
    PagingVO<PmsProjectConclusionVO> queryPagingJoinProject(PmsProjectConclusionQuery query);

    /**
     * 查询列表
     *
     * @param query 条件参数
     * @return {@link List}<{@link PmsProjectConclusionVO}>
     */
    List<PmsProjectConclusionVO> queryListDynamic(PmsProjectConclusionQuery query);

    /**
     * 通过主键查询
     *
     * @param key 主键
     * @return {@link PmsProjectConclusionVO}
     */
    PmsProjectConclusionVO queryByKey(Long key, String approvalNode);


    /**
     * 逻辑删除
     *
     * @param keys 主键集合
     */
    void deleteSoft(List<Long> keys);


    /**
     * 自动检查
     *
     * @param projectId
     */
    List<PmsInspectionItemConfigVO> autoCheck(Long projectId, String workType, String approvalNode);

    /**
     * 流程回调
     *
     * @param payload
     */
    void processStatusChange(ProcessStatusChangePayload payload);


    /**
     * 更改项目状态为待关账
     *
     * @param payload
     */
    void taskCreated(TaskCreatedPayload payload);

}
