package com.elitesland.tw.tw5.api.prd.shorturl.payload;

import com.elitesland.tw.tw5.api.common.TwCommonPayload;
import io.swagger.annotations.ApiModelProperty;
import lombok.Getter;
import lombok.Setter;

import java.io.Serializable;

/**
 * 短链服务配置
 *
 * @author duwh
 * @date 2023-05-19
 */
@Getter
@Setter
public class ShortUrlConfPayload extends TwCommonPayload  implements Serializable {

    /** 短链地址-相对地址 */
    @ApiModelProperty("短链地址-相对地址")
    private String shortUrlRelative;
    /** 短链地址前缀 */
    @ApiModelProperty("短链地址前缀")
    private String shortUrlPre;
    /** 长链地址后缀 */
    @ApiModelProperty("长链地址后缀")
    private String longUrlPre;
    /** 拓展1 */
    @ApiModelProperty("拓展1")
    private String ext1;
    /** 拓展2 */
    @ApiModelProperty("拓展2")
    private String ext2;
    /** 拓展3 */
    @ApiModelProperty("拓展3")
    private String ext3;
    /** 拓展4 */
    @ApiModelProperty("拓展4")
    private String ext4;
    /** 拓展5 */
    @ApiModelProperty("拓展5")
    private String ext5;
}
