package com.elitesland.tw.tw5.api.prd.system.vo;

import cn.hutool.core.util.StrUtil;
import com.elitescloud.boot.common.param.BaseViewModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Getter;
import lombok.Setter;
import org.springframework.util.StringUtils;

import java.io.Serializable;

/**
  * 业务对象字段明细
  *
  * @author duwh
  * @date 2023-06-14
  */
@Getter
@Setter
public class PrdSystemPermissionTableFieldsVO extends BaseViewModel implements Serializable {

    /** 业务对象主表主键 prd_business_table.id */
    private Long tableId;
    /** 字段 */
    @ApiModelProperty("字段")
    private String field;
    /** 字段类型(数据库) */
    @ApiModelProperty("字段类型(数据库)")
    private String type;
    /** 字段key */
    @ApiModelProperty("字段key")
    private String fieldKey;
    /** 字段名称 */
    @ApiModelProperty("字段名称")
    private String fieldName;
    /** 是否业务字段 */
    @ApiModelProperty("是否业务字段")
    private Boolean businessFlag;
    /** 是否必填 */
    @ApiModelProperty("是否必填")
    private Boolean notNull;
    /** 显示名称 */
    @ApiModelProperty("显示名称")
    private String showName;
    /** 业务类型 INPUT 文本输入 SELECT 选择器 */
    @ApiModelProperty("业务类型 INPUT 文本输入 SELECT 选择器")
    private String showType;
    /** 业务属性 JSON格式 */
    @ApiModelProperty("业务属性 JSON格式")
    private String showAttr;
    /** 默认值 */
    @ApiModelProperty("default值")
    private String defaultValue;
    /** 正则验证 */
    @ApiModelProperty("正则验证")
    private String regexVerify;
    /** 排序号 */
    @ApiModelProperty("排序号")
    private Integer sortNo;
    /** 拓展字段1 extra */
    @ApiModelProperty("拓展字段1 extra")
    private String ext1;
    /** 拓展字段2 keyType */
    @ApiModelProperty("拓展字段2 keyType")
    private String ext2;
    /** 拓展字段3 */
    @ApiModelProperty("拓展字段3")
    private String ext3;

    public PrdSystemPermissionTableFieldsVO() {
    }

    public PrdSystemPermissionTableFieldsVO(String tableName, String columnName, Boolean notNull, String columnType, String remark, String keyType, String extra, String defaultValue) {
        // this.tableName = tableName;
        // 默认业务字段
        this.businessFlag = true;
        this.field = columnName;
        if(StringUtils.hasText(columnName)){
            this.fieldKey = StrUtil.toCamelCase(columnName);

            if(columnName.equals("remark")
            ||columnName.equals("create_user_id")
            ||columnName.equals("creator")
            ||columnName.equals("create_time")
            ||columnName.equals("modify_user_id")
            ||columnName.equals("updater")
            ||columnName.equals("modify_time")
            ){
                this.businessFlag = false;
            }
        }
        this.type = columnType;
        this.ext2 = keyType;
        this.ext1 = extra;
        this.notNull = notNull;
        if("PRI".equalsIgnoreCase(keyType) && "auto_increment".equalsIgnoreCase(extra)){
            this.notNull = false;
            this.businessFlag = false;
        }

        this.fieldName = remark;
        this.showName = remark;
        this.defaultValue = defaultValue;

    }
}
