package com.elitesland.tw.tw5.api.common.funConfig.service;

import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.tw.tw5.api.common.funConfig.payload.BusinessDocTypeRefPayload;
import com.elitesland.tw.tw5.api.common.funConfig.query.BusinessDocTypeRefQuery;
import com.elitesland.tw.tw5.api.common.funConfig.vo.BusinessDocTypeRefVO;

import java.util.List;

/**
 * 易稻壳yeedoc通用文档类型配置与业务关系表
 *
 * @author duwh
 * @date 2023-12-08
 */
public interface BusinessDocTypeRefService {

    /**
     * 分页列表
     *
     * @param query 条件
     * @return {@link PagingVO}<{@link BusinessDocTypeRefVO}>
     */
    PagingVO<BusinessDocTypeRefVO> queryPaging(BusinessDocTypeRefQuery query);

    /**
     * 查询列表
     *
     * @param query 条件参数
     * @return {@link List}<{@link BusinessDocTypeRefVO}>
     */
    List<BusinessDocTypeRefVO> queryListDynamic(BusinessDocTypeRefQuery query);

    /**
     * 通过主键查询
     *
     * @param key 主键
     * @return {@link BusinessDocTypeRefVO}
     */
    BusinessDocTypeRefVO queryByKey(Long key);

    /**
     * 新增
     *
     * @param payload 单据数据
     * @return {@link BusinessDocTypeRefVO}
     */
    BusinessDocTypeRefVO insert(BusinessDocTypeRefPayload payload);

    /**
     * 修改
     *
     * @param payload 单据数据
     * @return {@link BusinessDocTypeRefVO}
     */
    BusinessDocTypeRefVO update(BusinessDocTypeRefPayload payload);

    /**
     * 修改,置空的字段需需要借助 protected List<String> nullFields;
     *
     * @param payload 单据数据
     * @return {@link long}
     */
    long updateByKeyDynamic(BusinessDocTypeRefPayload payload);

    /**
     * 逻辑删除
     *
     * @param keys 主键集合
     */
    void deleteSoft(List<Long> keys);


    /**
     * 按单据类型和单据id获取
     *
     * @param docType      单据类型
     * @param docId        文档id
     * @param configRuleId 规则id
     * @return {@link BusinessDocTypeRefVO}
     */
    BusinessDocTypeRefVO getByDocTypeAndDocIdAndRuleId(String docType, Long docId, Long configRuleId);
}
