package com.elitesland.tw.tw5.api.prd.cal.query;

import com.elitesland.tw.tw5.api.common.TwQueryParam;
import io.swagger.annotations.ApiModelProperty;
import lombok.Getter;
import lombok.Setter;
import org.springframework.format.annotation.DateTimeFormat;

import java.io.Serializable;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.time.LocalDateTime;

/**
 * 泛用金额结算管理
 *
 * @author carl
 * @date 2023-11-20
 */
@Getter
@Setter
public class CalNormSettleQuery extends TwQueryParam implements Serializable {
    /**
     * 主键 精确
     */
    @ApiModelProperty("主键")
    private Long id;
    /**
     * 结算单号 精确
     */
    @ApiModelProperty("结算单号")
    private String settleNo;
    /**
     * 结算状态 精确
     */
    @ApiModelProperty("结算状态")
    private String settleStatus;
    /**
     * 审批状态 精确
     */
    @ApiModelProperty("审批状态")
    private String apprStatus;
    /**
     * 流程实例id 精确
     */
    @ApiModelProperty("流程实例id")
    private String procInstId;
    /**
     * 单据创建类型 精确
     */
    @ApiModelProperty("单据创建类型")
    private String createType;
    /**
     * 业务类型 精确
     */
    @ApiModelProperty("业务类型")
    private String busiType;
    /**
     * 相关业务单据号 精确
     */
    @ApiModelProperty("相关业务单据号")
    private String relevNo;
    /**
     * 申请日期 精确
     */
    @ApiModelProperty("申请日期")
    @DateTimeFormat(pattern = "yyyy-MM-dd")
    private LocalDateTime applyDate;
    /**
     * 申请资源id 精确
     */
    @ApiModelProperty("申请资源id")
    private Long applyResId;
    /**
     * 结算日期 精确
     */
    @ApiModelProperty("结算日期")
    @DateTimeFormat(pattern = "yyyy-MM-dd")
    private LocalDate settleDate;
    /**
     * 结算开始日期 精确
     */
    @ApiModelProperty("结算开始日期")
    @DateTimeFormat(pattern = "yyyy-MM-dd")
    private LocalDate settleStartDate;
    /**
     * 结算结束日期 精确
     */
    @ApiModelProperty("结算结束日期")
    @DateTimeFormat(pattern = "yyyy-MM-dd")
    private LocalDate settleEndDate;
    /**
     * 财务期间id 精确
     */
    @ApiModelProperty("财务期间id")
    private Long finPeriodId;
    /**
     * 子合同id 精确
     */
    @ApiModelProperty("子合同id")
    private Long contractId;
    /**
     * 项目id 精确
     */
    @ApiModelProperty("项目id")
    private Long projId;
    /**
     * 任务id 精确
     */
    @ApiModelProperty("任务id")
    private Long taskId;
    /**
     * 收入方账户 精确
     */
    @ApiModelProperty("收入方账户")
    private String inAccount;
    /**
     * 收入方科目 精确
     */
    @ApiModelProperty("收入方科目")
    private String inAcc;
    /**
     * 支出方账户 精确
     */
    @ApiModelProperty("支出方账户")
    private String outAccount;
    /**
     * 支出方科目 精确
     */
    @ApiModelProperty("支出方科目")
    private String outAcc;
    /**
     * 收入方账户id
     */
    @ApiModelProperty("收入方账户id")
    private Long inAccountId;

    /**
     * 支出方账户id
     */
    @ApiModelProperty("支出方账户id")
    private Long outAccountId;
    /**
     * 实际结算总额 精确
     */
    @ApiModelProperty("实际结算总额")
    private BigDecimal approveSettleAmt;
    /**
     * 税额 精确
     */
    @ApiModelProperty("税额")
    private BigDecimal taxAmt;
    /**
     * 申请人bu_id 精确
     */
    @ApiModelProperty("申请人bu_id")
    private Long applyBuId;
    /**
     * 收款计划id 精确
     */
    @ApiModelProperty("收款计划id")
    private Long recvplanId;
}
