package com.elitesland.tw.tw5.api.prd.file.payload;

import com.elitesland.tw.tw5.api.common.TwCommonPayload;
import lombok.Builder;
import lombok.Data;

/**
 * 附件 文件
 *
 * @author duwh
 * @date 2022/09/20
 */
@Data
@Builder
public class PrdFilePayload extends TwCommonPayload {

    /**
     * 文件夹主键
     */
    private Long folderId;

    /**
     * 文件名称
     */
    private String name;

    /**
     * 原文件名称
     */
    private String fileName;

    /**
     * 真实文件名
     */
    private String realName;

    /**
     * 文件路径
     */
    private String serverPath;

    /**
     * 格式后缀
     */
    private String suffix;

    /**
     * 文件类型
     */
    private String fileType;

    /**
     * 文件类型desc
     */
    private String fileTypeDesc;

    /**
     * 文件大小(字节)
     */
    private Long fileSize;

    private String fileSizeDesc;

    /**
     * 最新版本主键
     */
    private Long versionId;

    /**
     * 最新版本号
     */
    private String versionNo;

    /**
     * 版本标记
     * 版本文件，0：非版本文件，1：版本文件
     */
    private Integer versionFlag;

}
