package com.elitesland.tw.tw5.api.prd.humanresources.vo;

import com.elitescloud.boot.common.param.BaseViewModel;
import com.elitesland.tw.tw5.api.udc.UdcName;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.time.LocalDate;

@Data
public class PersonEduExperienceVO extends BaseViewModel {

    @ApiModelProperty("人员id")
    private Long personId;

    @ApiModelProperty("开始时间")
    private LocalDate dateFrom;

    @ApiModelProperty("结束时间")
    private LocalDate dateTo;

    @ApiModelProperty("学校名称")
    private String schoolName;

    @ApiModelProperty("专业名称")
    private String majorName;

    @ApiModelProperty("学历")
    private String qualification;
    @UdcName(udcName = "org:employee:education", codePropName = "qualification")
    private String qualificationName;

    @ApiModelProperty("学制")
    private String edusysType;
    @UdcName(udcName = "org:employee:education_type", codePropName = "edusysType")
    private String edusysTypeName;


    @ApiModelProperty("专业描述")
    private String majorDesc;

}
