package com.elitesland.tw.tw5.api.prd.my.query;

import com.elitesland.tw.tw5.api.common.TwQueryParam;
import io.swagger.annotations.ApiModelProperty;
import lombok.Getter;
import lombok.Setter;
import org.springframework.format.annotation.DateTimeFormat;

import java.io.Serializable;
import java.time.LocalDate;
import java.util.List;

@Getter
@Setter
public class TAttendanceNormalQuery extends TwQueryParam implements Serializable {
    /**
     * 记录唯一ID 精确
     */
    @ApiModelProperty("记录唯一ID")
    private Long id;
    /**
     * 打卡人员ID 精确
     */
    @ApiModelProperty("打卡人员ID")
    private Long attendanceResId;

    /**
     * 打卡人员部门ID
     */
    @ApiModelProperty("打卡人员部门ID")
    private Long orgId;
    /**
     * 打卡日期 精确
     */
    @ApiModelProperty("打卡日期")
    private LocalDate attendanceDate;

    /**
     * 打卡日期 精确
     */
    @ApiModelProperty("打卡日期")
    @DateTimeFormat(pattern = "yyyy-MM-dd")
    private List<LocalDate> attendanceDates;

    /**
     * 打卡月份 精确
     */
    @ApiModelProperty("打卡月份")
    private List<String> attendanceMonths;

    /**
     * 规则ID 精确
     */
    @ApiModelProperty("规则ID")
    private Long attendanceRuleId;
    /**
     * 上班时间 精确
     */
    @ApiModelProperty("上班时间")
    private String attendanceTimeStart;
    /**
     * 下班时间 精确
     */
    @ApiModelProperty("下班时间")
    private String attendanceTimeEnd;
    /**
     * 打卡结果 YSE/NO 精确
     */
    @ApiModelProperty("打卡结果 YSE/NO")
    private String attendanceResult;
    /**
     * 正常、迟到或早退、矿工 精确
     */
    @ApiModelProperty("正常、迟到或早退、矿工")
    private String attendanceResultDetail;
    /**
     * 特殊打卡原因 精确
     */
    @ApiModelProperty("特殊打卡原因")
    private String specialReason;
    /**
     * 打卡设备 精确
     */
    @ApiModelProperty("打卡设备")
    private String attendanceDevice;

    @ApiModelProperty("打卡经度")
    private String attendanceSiteLongitude;

    @ApiModelProperty("打卡纬度")
    private String attendanceSiteLatitude;

    @ApiModelProperty("打卡位置")
    private String attendanceLocation;

    @ApiModelProperty("打卡城市")
    private String attendanceCity;

    @ApiModelProperty("主服务地")
    private String baseCity;

    @ApiModelProperty("资源经理")
    private Long resManagerId;
}

