package com.elitesland.tw.tw5.api.prd.salecon.payload;

import com.elitesland.tw.tw5.api.common.TwCommonPayload;
import com.elitesland.workflow.enums.ProcInstStatus;
import io.swagger.annotations.ApiModelProperty;
import lombok.Getter;
import lombok.Setter;
import org.springframework.format.annotation.DateTimeFormat;

import java.io.Serializable;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.time.LocalDateTime;

/**
 * 销售合同
 *
 * @author danting
 * @date 2023-03-30
 */
@Getter
@Setter
public class SaleConContractPayload extends TwCommonPayload implements Serializable {
    /**
     * 合同编号
     */
    @ApiModelProperty("合同编号")
    private String code;
    /**
     * 合同名称
     */
    @ApiModelProperty("合同名称")
    private String name;
    /**
     * 合同状态
     */
    @ApiModelProperty("合同状态")
    private String status;
//    /**
//     * 签约公司ID
//     */
//    @ApiModelProperty("签约公司ID")
//    private Long ouId;

    /**
     * 签约公司ID
     */
    @ApiModelProperty("签约公司ID")
    private Long ouBookId;
    /**
     * 参考合同号
     */
    @ApiModelProperty("参考合同号")
    private String referCode;
    /**
     * 商机ID
     */
    @ApiModelProperty("商机ID")
    private Long oppoId;
    /**
     * 客户ID
     */
    @ApiModelProperty("客户ID")
    private Long custId;
    /**
     * 签约时客户名称
     */
    @ApiModelProperty("签约时客户名称")
    private String custName;
    /**
     * 关联合同ID
     */
    @ApiModelProperty("关联合同ID")
    private Long relatedContractId;
    /**
     * 新客户标志，0：新客户，1：老客户
     */
    @ApiModelProperty("新客户标志，0：新客户，1：老客户")
    private Long custFlag;
    /**
     * 签订日期
     */
    @ApiModelProperty("签订日期")
    @DateTimeFormat(pattern = "yyyy-MM-dd")
    private LocalDate signDate;
    /**
     * 特别关注点
     */
    @ApiModelProperty("特别关注点")
    private String specialConcerned;
    /**
     * 币种
     */
    @ApiModelProperty("币种")
    private String currCode;
    /**
     * 关闭原因
     */
    @ApiModelProperty("关闭原因")
    private String closeReason;
    /**
     * 关闭时间
     */
    @ApiModelProperty("关闭时间")
    @DateTimeFormat(pattern = "yyyy-MM-dd")
    private LocalDate closeDate;
    /**
     * 客户项目
     */
    @ApiModelProperty("客户项目")
    private String custProj;
    /**
     * 销售内容
     */
    @ApiModelProperty("销售内容")
    private String saleContent;
    /**
     * 产品大类
     */
    @ApiModelProperty("产品大类")
    private String productClass;
    /**
     * 产品小类
     */
    @ApiModelProperty("产品小类")
    private String productSubClass;
    /**
     * 交付地点
     */
    @ApiModelProperty("交付地点")
    private String deliveryAddress;
    /**
     * 财务期间ID
     */
    @ApiModelProperty("财务期间ID")
    private Long finPeriodId;
    /**
     * 合同总金额
     */
    @ApiModelProperty("合同总金额")
    private BigDecimal amt;
    /**
     * 其它费用
     */
    @ApiModelProperty("其它费用")
    private BigDecimal extraAmt;
    /**
     * 有效合同金额
     */
    @ApiModelProperty("有效合同金额")
    private BigDecimal effectiveAmt;
    /**
     * 相关项目采购
     */
    @ApiModelProperty("相关项目采购")
    private BigDecimal demandTotalAmt;
    /**
     * 毛利
     */
    @ApiModelProperty("毛利")
    private BigDecimal grossProfit;
    /**
     * 销售区域BU_ID
     */
    @ApiModelProperty("销售区域BU_ID")
    private Long regionBuId;
    /**
     * 销售区域负责人
     */
    @ApiModelProperty("销售区域负责人")
    private Long regionUserId;
    /**
     * 签单BU_ID
     */
    @ApiModelProperty("签单BU_ID")
    private Long signBuId;
    /**
     * 副签单BU_ID
     */
    @ApiModelProperty("副签单BU_ID")
    private Long coSignBuId;
    /**
     * 副签单用户id
     */
    @ApiModelProperty("副签单用户id")
    private Long coSignUserId;
    /**
     * 交付BU_ID
     */
    @ApiModelProperty("交付BU_ID")
    private Long deliBuId;
    /**
     * 交付用户id
     */
    @ApiModelProperty("交付用户id")
    private Long deliUserId;
    /**
     * 副交付BU_ID
     */
    @ApiModelProperty("副交付BU_ID")
    private Long codeliBuId;
    /**
     * 副交付用户id
     */
    @ApiModelProperty("副交付用户id")
    private Long codeliUserId;
    /**
     * 平台合同类型
     */
    @ApiModelProperty("平台合同类型")
    private String platType;
    /**
     * 主合同类型
     */
    @ApiModelProperty("主合同类型")
    private String mainType;
    /**
     * PMO用户ID
     */
    @ApiModelProperty("PMO用户ID")
    private Long pmoUserId;
    /**
     * 来源类型
     */
    @ApiModelProperty("来源类型")
    private String sourceType;
    /**
     * 外部来源
     */
    @ApiModelProperty("外部来源")
    private String externalIden;
    /**
     * 外部来源人
     */
    @ApiModelProperty("外部来源人")
    private String externalName;
    /**
     * 外部来源电话
     */
    @ApiModelProperty("外部来源电话")
    private String externalPhone;
    /**
     * 内部来源BU_ID
     */
    @ApiModelProperty("内部来源BU_ID")
    private Long internalBuId;
    /**
     * 利益承诺
     */
    @ApiModelProperty("利益承诺")
    private String profitDesc;
    /**
     * 税率
     */
    @ApiModelProperty("税率")
    private BigDecimal taxRate;
    /**
     * 销售人员用户ID
     */
    @ApiModelProperty("销售人员用户ID")
    private Long saleManUserId;
    /**
     * 内部来源用户ID
     */
    @ApiModelProperty("内部来源用户ID")
    private Long internalUserId;
    /**
     * 内部来源用户id
     */
    private String internalUserName;
    /**
     * 合同开始日期
     */
    @ApiModelProperty("合同开始日期")
    @DateTimeFormat(pattern = "yyyy-MM-dd")
    private LocalDate startDate;
    /**
     * 合同结束日期
     */
    @ApiModelProperty("合同结束日期")
    @DateTimeFormat(pattern = "yyyy-MM-dd")
    private LocalDate endDate;
    /**
     * 纸质合同状态描述
     */
    @ApiModelProperty("纸质合同状态描述")
    private String paperDesc;
    /**
     * 纸质合同状态
     */
    @ApiModelProperty("纸质合同状态")
    private String paperStatus;
    /**
     * 合同激活时间
     */
    @DateTimeFormat(pattern = "yyyy-MM-dd")
    @ApiModelProperty("合同激活时间")
    private LocalDate acitveDate;
    /**
     * 产品
     */
    @ApiModelProperty("产品")
    private Long product;
    /**
     * 简要说明
     */
    @ApiModelProperty("简要说明")
    private String briefDesc;
    /**
     * 工作类型
     */
    @ApiModelProperty("工作类型")
    private String workType;
    /**
     * 促销类型
     */
    @ApiModelProperty("促销类型")
    private String promotionType;
    /**
     * 范围性质
     */
    @ApiModelProperty("范围性质")
    private String rangeProp;
    /**
     * 半开口说明
     */
    @ApiModelProperty("半开口说明")
    private String halfOpenDesc;
    /**
     * 供应主体类别
     */
    @ApiModelProperty("供应主体类别")
    private String supplierType;
    /**
     * 提成类别
     */
    @ApiModelProperty("提成类别")
    private String commissionType;
    /**
     * 交易方式
     */
    @ApiModelProperty("交易方式")
    private String transactionMethod;
    /**
     * 交易性质
     */
    @ApiModelProperty("交易性质")
    private String transactionNature;
    /**
     * 需求类别
     */
    @ApiModelProperty("需求类别")
    private String demandType;
    /**
     * 销售分类
     */
    @ApiModelProperty("销售分类")
    private String saleClass;
    /**
     * 客户承担差旅费
     */
    @ApiModelProperty("客户承担差旅费")
    private String custBarExpense;
    /**
     * 报销政策说明
     */
    @ApiModelProperty("报销政策说明")
    private String reimbursementDesc;
    /**
     * 估算当量
     */
    @ApiModelProperty("估算当量")
    private BigDecimal ratedEqva;
    /**
     * 估算费用
     */
    @ApiModelProperty("估算费用")
    private BigDecimal ratedExpense;
    /**
     * 合同打印方
     */
    @ApiModelProperty("合同打印方")
    private String contractPrinter;
    /**
     * 打印份数
     */
    @ApiModelProperty("打印份数")
    private Long printCount;
    /**
     * 盖章类型
     */
    @ApiModelProperty("盖章类型")
    private String sealType;
    /**
     * 和发票一起邮寄，0：是，1：否
     */
    @ApiModelProperty("和发票一起邮寄，0：是，1：否")
    private Integer sendWithInvoiceFlag;
    /**
     * 邮寄地址
     */
    @ApiModelProperty("邮寄地址")
    private String mailingAddress;
    /**
     * 父ID
     */
    @ApiModelProperty("父ID")
    private Long parentId;

    @ApiModelProperty("易道壳的文件夹id")
    private String folderId;

    @ApiModelProperty("易道壳的authToken")
    private String authTokenByYdk;

    /**
     * 合同附件
     */
    @ApiModelProperty("合同附件")
    private String fileCodes;

    @ApiModelProperty("合同附件易道壳缓存key")
    private String cacheKey;

    /**
     * SOW附件
     */
    @ApiModelProperty("SOW附件")
    private String sowFileCodes;

    @ApiModelProperty("SOW附件易道壳缓存key")
    private String sowCacheKey;

    /**
     * 估算申请单附件
     */
    @ApiModelProperty("估算申请单附件")
    private String assessFileCodes;

    @ApiModelProperty("估算申请单附件易道壳缓存key")
    private String assessCacheKey;

    /**
     * 合同关闭附件
     */
    @ApiModelProperty("合同关闭附件")
    private String closeFileCodes;

    @ApiModelProperty("合同关闭易道壳缓存key")
    private String closeCacheKey;

    /**
     * 售前bu
     */
    @ApiModelProperty("售前bu")
    private Long preSaleBuId;

    /**
     * 售前负责人
     */
    @ApiModelProperty("售前负责人")
    private Long preSaleUserId;

//    @ApiModelProperty("流程提交标志")
//    private Boolean submit;

    @ApiModelProperty("流程实例ID")
    private String procInstId;

    @ApiModelProperty("流程审批状态")
    private ProcInstStatus procInstStatus;

    @ApiModelProperty("提交时间")
    private LocalDateTime submitTime;

    @ApiModelProperty("审批时间")
    private LocalDateTime approvedTime;

    @ApiModelProperty("财务核算毛利率")
    private BigDecimal finGross;

    @ApiModelProperty("财务核定额定当量")
    private BigDecimal finRatedEqva;

    @ApiModelProperty("系统核算毛利率")
    private BigDecimal sysGross;

    @ApiModelProperty("净Rate")
    private BigDecimal netRate;

    @ApiModelProperty("额定费用")
    private BigDecimal ratedCost;

    @ApiModelProperty("附件标志,true需要，false不需要")
    private Boolean fileFlag;

    /**
     * 变更中标志 0:否 1:是
     */
    @ApiModelProperty("变更中标志 0:否 1:是")
    private Integer changeFlag = 0;

    @ApiModelProperty("流程提交标志")
    private Boolean submit;

    @ApiModelProperty("子合同变更单据id")
    private Long changeBusinesskey;

    @ApiModelProperty("合同收回时间")
    private LocalDateTime receiveTime;

    @ApiModelProperty("是否有代理费 1是  0否")
    private Integer agentFlag;
    @ApiModelProperty("代理费比例")
    private BigDecimal agentProportion;
    @ApiModelProperty("代理费金额")
    private BigDecimal agentAmt;
    /** 平台提成比例 */
    @ApiModelProperty("平台提成比例")
    private BigDecimal percentage;
    @ApiModelProperty("拓展")
    private String ext1;
    @ApiModelProperty("拓展")
    private String ext2;
    @ApiModelProperty("拓展")
    private String ext3;
    @ApiModelProperty("拓展")
    private String ext4;
    @ApiModelProperty("拓展")
    private String ext5;
    @ApiModelProperty("合同归档标志")
    private Integer filingFlag;
}
