package com.elitesland.tw.tw5.api.prd.visit.query;

import com.elitesland.tw.tw5.api.common.TwQueryParam;
import com.elitesland.tw.tw5.api.common.annotation.Query;
import io.swagger.annotations.ApiModelProperty;
import lombok.Getter;
import lombok.Setter;

import java.io.Serializable;

/**
 * 销售拜访计划成员
 *
 * @author liwenpeng
 * @date 2023-03-14
 */
@Getter
@Setter
public class VisitPlanDetailQuery extends TwQueryParam implements Serializable{
    /** 记录唯一ID 精确 */
    @ApiModelProperty("记录唯一ID")
    @Query
    private Long id;
    /** 拜访计划id 精确 */
    @ApiModelProperty("拜访计划id")
    @Query
    private Long visitPlanId;
    /** 拜访人员id 精确 */
    @ApiModelProperty("拜访人员id")
    @Query
    private Long visitPersonId;
    /** 拜访成员类型，0：拜访成员，1：协访成员 精确 */
    @ApiModelProperty("拜访成员类型，0：拜访成员，1：协访成员")
    @Query
    private String visitPersonType;
}
