package com.elitesland.tw.tw5.api.prd.acc.payload;

import com.elitesland.tw.tw5.api.common.TwCommonPayload;
import io.swagger.annotations.ApiModelProperty;
import lombok.Getter;
import lombok.Setter;

import java.io.Serializable;
import java.math.BigDecimal;

/**
 * 差旅报销额度管理
 *
 * @author sunxw
 * @date 2023-12-04
 */
@Getter
@Setter
public class AccReimTripStdPayload extends TwCommonPayload implements Serializable {
    /**
     * P职级区间下限
     */
    @ApiModelProperty("P职级区间下限")
    private String jobGradePlLow;
    /**
     * P职级区间上限
     */
    @ApiModelProperty("P职级区间上限")
    private String jobGradePlUp;
    /**
     * M职级区间下限
     */
    @ApiModelProperty("M职级区间下限")
    private String jobGradeMlLow;
    /**
     * M职级区间上限
     */
    @ApiModelProperty("M职级区间上限")
    private String jobGradeMlUp;
    /**
     * FEE_TYPE
     */
    @ApiModelProperty("FEE_TYPE")
    private String feeType;
    /**
     * 城市级别
     */
    @ApiModelProperty("城市级别")
    private String cityLevel;
    /**
     * 项目报销级别
     */
    @ApiModelProperty("项目报销级别")
    private Integer projectFeeLevel;
    /**
     * 报销额度
     */
    @ApiModelProperty("报销额度")
    private BigDecimal feeAmt;
}
