package com.elitesland.tw.tw5.api.prd.acc.query;

import com.elitesland.tw.tw5.api.common.TwQueryParam;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import org.springframework.format.annotation.DateTimeFormat;

import java.io.Serializable;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.util.List;

/**
 * 费用报销
 *
 * @author sunxw
 * @date 2023-11-22
 */
@Data
public class AccReimQuery extends TwQueryParam implements Serializable {

    @ApiModelProperty("报销单号")
    private String reimNo;

    @ApiModelProperty("报销人USER_ID")
    private Long reimUserId;

    @ApiModelProperty("我的报销USER_ID -我的报销分页/列表时时使用")
    private Long myReimUserId;

    @ApiModelProperty("报销人ORG_ID")
    private Long reimOrgId;

    @ApiModelProperty("报销人职级")
    private String reimResGrade;

    @ApiModelProperty("报销类型")
    private String reimType;

    @ApiModelProperty("单据类型")
    private String reimDocType;

    @ApiModelProperty("相关申请单")
    private Long relatedDocId;

    @ApiModelProperty("相关预算")
    private Long relatedBudgetId;

    /**
     * 费用归属 【P_reim_.expense_classification】
     */
    @ApiModelProperty("费用归属")
    private String expenseClassification;

    @ApiModelProperty("费用承担项目")
    private Long expenseProjectId;

    @ApiModelProperty("费用承担部门")
    private Long expenseOrgId;

    @ApiModelProperty("费用承担公司")
    private Long expenseCompany;

    @ApiModelProperty("记账日期")
    private LocalDateTime accountingDate;
    @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    private LocalDateTime accountingDateStart;
    @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    private LocalDateTime accountingDateEnd;

    @ApiModelProperty("报销单状态")
    private String reimStatus;

    @ApiModelProperty("报销说明")
    private String reimRemark;

    @ApiModelProperty("报销总额")
    private BigDecimal reimTotalAmt;

    @ApiModelProperty("调整后费用")
    private BigDecimal adjustAmt;

    @ApiModelProperty("支付金额")
    private BigDecimal payAmt;

    @DateTimeFormat(pattern = "yyyy-MM-dd")
    @ApiModelProperty("付款日期")
    private LocalDateTime payDate;
    @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    private LocalDateTime payDateStart;
    @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    private LocalDateTime payDateEnd;

    @ApiModelProperty("事由类型")
    private String reasonType;

    @ApiModelProperty("事由号")
    private Long reasonId;

    @ApiModelProperty("事由名称")
    private String reasonName;

    @ApiModelProperty("支付方式")
    private String payMethod;

    @ApiModelProperty("收款账户")
    private String accountNo;

    @ApiModelProperty("户名")
    private String holderName;

    @ApiModelProperty("收款银行")
    private String bankName;

    @ApiModelProperty("收款银行网点")
    private String bankBranch;

    @ApiModelProperty("付款方式：1.网银支付 2.手动支付")
    private String payMode;

    @ApiModelProperty("付款银行账号")
    private String payAccountNo;

    @ApiModelProperty("费用承担方")
    private String expenseByType;

    @ApiModelProperty("审批状态")
    private String apprStatus;

    @ApiModelProperty("ID不在")
    private Long notId;

    @ApiModelProperty("流程实例id")
    private String procInstId;

    @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    @ApiModelProperty("财务收单时间")
    private LocalDateTime finChargeUpTime;
    @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    private LocalDateTime finChargeUpTimeStart;
    @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    private LocalDateTime finChargeUpTimeEnd;

    @ApiModelProperty("报销导出批次号，T_ACC_PAY_BATCH.BATCH_NO")
    private String batchNo;

    @ApiModelProperty("报销导出批次号集合")
    private List<String> batchNoList;

    @ApiModelProperty("新批次号")
    private String batchNoLast;

    @ApiModelProperty("支付状态：S 成功、F 失败、C 撤销、D 过期、R 否决 G退票")
    private String payStatus;

    @ApiModelProperty("网银提交标识 1.已提交 2.未提交")
    private Integer bankFlag;

    @ApiModelProperty("申请日期")
    private LocalDate applyDate;
    @ApiModelProperty("申请日期始")
    @DateTimeFormat(pattern = "yyyy-MM-dd")
    private LocalDate applyDateStart;
    @ApiModelProperty("申请日期止")
    @DateTimeFormat(pattern = "yyyy-MM-dd")
    private LocalDate applyDateEnd;

    @ApiModelProperty("财务负责人审批时间")
    private LocalDateTime finPicApprTime;
    @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    private LocalDateTime finPicApprTimeStart;
    @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    private LocalDateTime finPicApprTimeEnd;

    @ApiModelProperty("流程节点名称")
    private String apprProcName;

    @ApiModelProperty("主键集合")
    private List<Long> idList;

    @ApiModelProperty("事由类型集合")
    private List<String> reasonTypeList;

    @ApiModelProperty("事由id集合")
    private List<Long> reasonIdList;

    @ApiModelProperty("报销单据状态集合")
    private List<String> reimStatusList;

    @ApiModelProperty("报销单据状态不在集合")
    private List<String> notReimStatusList;

    @ApiModelProperty("预算项目ID")
    private Long budgetItemId;

    @ApiModelProperty("预算项目ID集合")
    private List<Long> budgetItemIdList;

    @ApiModelProperty("财务期间ID")
    private Long finPeriodId;

    @ApiModelProperty("费用发生日期")
    private LocalDate expenseDate;

    @ApiModelProperty("费用发生日期起")
    private LocalDate expenseDateStart;
    @ApiModelProperty("费用发生日期止")
    private LocalDate expenseDateEnd;

    /***jde新增字段***/

    @ApiModelProperty("费用凭证摘要")
    private String expenseProofDigest;

    @ApiModelProperty("费用凭证号")
    private String expenseProofNo;

    @ApiModelProperty("费用凭证状态")
    private String expenseProofStatus;

    @ApiModelProperty("付款凭证摘要")
    private String payProofDigest;

    @ApiModelProperty("付款凭证号")
    private String payProofNo;

    @ApiModelProperty("付款凭证状态")
    private String payProofStatus;

    @ApiModelProperty("财务付款记账审批开始时间")
    @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    private LocalDateTime payApprovedTimeStart;

    @ApiModelProperty("财务付款记账审批结束时间")
    @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    private LocalDateTime payApprovedTimeEnd;

    @ApiModelProperty("是否异常")
    private Integer abnormalFlag;
}
