package com.elitesland.tw.tw5.api.prd.adm.query;

import com.elitesland.tw.tw5.api.common.TwQueryParam;
import io.swagger.annotations.ApiModelProperty;
import lombok.Getter;
import lombok.Setter;
import org.springframework.format.annotation.DateTimeFormat;

import java.io.Serializable;
import java.math.BigDecimal;
import java.time.LocalDate;

/**
 * 特殊费用申请管理
 *
 * @author carl
 * @date 2023-11-01
 */
@Getter
@Setter
public class AdmFeeApplyQuery extends TwQueryParam implements Serializable {
    /**
     * 主键 精确
     */
    @ApiModelProperty("主键")
    private Long id;
    /**
     * 申请单号 模糊
     */
    @ApiModelProperty("申请单号")
    private String applyNo;
    /**
     * 申请单名称 模糊
     */
    @ApiModelProperty("申请单名称")
    private String applyName;
    /**
     * 申请状态 精确
     */
    @ApiModelProperty("申请状态")
    private String applyStatus;
    /**
     * 审批状态 精确
     */
    @ApiModelProperty("审批状态")
    private String apprStatus;
    /**
     * 流程实例id 精确
     */
    @ApiModelProperty("流程实例id")
    private String procInstId;
    /**
     * 申请日期 精确
     */
    @ApiModelProperty("申请日期")
    private LocalDate applyDate;
    /**
     * 财务期间id 精确
     */
    @ApiModelProperty("财务期间id")
    private Long finPeriodId;
    /**
     * 用途类型 精确
     */
    @ApiModelProperty("用途类型")
    private String usageType;
    /**
     * 事由类型 精确
     */
    @ApiModelProperty("事由类型")
    private String reasonType;
    /**
     * 事由id 精确
     */
    @ApiModelProperty("事由id")
    private Long reasonId;
    /**
     * 事由名称
     */
    @ApiModelProperty("事由名称")
    private String reasonName;
    /**
     * 费用承担方（类型） 精确
     */
    @ApiModelProperty("费用承担方（类型）")
    private String expenseByType;
    /**
     * 费用承担bu_id 精确
     */
    @ApiModelProperty("费用承担bu_id")
    private Long expenseBuId;
    /**
     * 费用承担公司id 精确
     */
    @ApiModelProperty("费用承担公司id")
    private Long ouId;
    /**
     * 费用归属bu_id 精确
     */
    @ApiModelProperty("费用归属bu_id")
    private Long sumBuId;
    /**
     * 申请人资源id 精确
     */
    @ApiModelProperty("申请人资源id")
    private Long applyResId;
    /**
     * 申请人bu_id 精确
     */
    @ApiModelProperty("申请人bu_id")
    private Long applyBuId;
    /**
     * 申请金额 精确
     */
    @ApiModelProperty("申请金额")
    private BigDecimal applyAmt;
    /**
     * 币种 精确
     */
    @ApiModelProperty("币种")
    private String currCode;
    /**
     * 预计使用开始日期 精确
     */
    @ApiModelProperty("预计使用日期")
    @DateTimeFormat(pattern = "yyyy-MM-dd")
    private LocalDate expectBeginDate;
    /**
     * 预计使用开始日期 精确
     */
    @ApiModelProperty("预计使用日期")
    @DateTimeFormat(pattern = "yyyy-MM-dd")
    private LocalDate expectEndDate;


    /**
     * 报销模板id 精确
     */
    @ApiModelProperty("报销模板id")
    private Long reimTmplId;
    /**
     * 客户id 精确
     */
    @ApiModelProperty("客户id")
    private Long custId;
    /**
     * 项目非项目 精确
     */
    @ApiModelProperty("项目非项目")
    private String applyType;
    /**
     * 费用码 精确
     */
    @ApiModelProperty("费用码")
    private String feeCode;

    @ApiModelProperty("是否被报销单关联 0-未关联 1-已关联")
    private Integer reimRelateFlag;
}
