package com.elitesland.tw.tw5.api.prd.cal.service;

import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.tw.tw5.api.prd.cal.payload.CalEqvaIncomePayload;
import com.elitesland.tw.tw5.api.prd.cal.query.CalEqvaIncomeQuery;
import com.elitesland.tw.tw5.api.prd.cal.vo.CalEqvaIncomeVO;

import java.util.List;

/**
 * 当量收入配置管理
 *
 * @author carl
 * @date 2023-11-07
 */
public interface CalEqvaIncomeService {

    /**
     * 分页列表
     *
     * @param query 条件
     * @return {@link PagingVO}<{@link CalEqvaIncomeVO}>
     */
    PagingVO<CalEqvaIncomeVO> queryPaging(CalEqvaIncomeQuery query);

    /**
     * 查询列表
     *
     * @param query 条件参数
     * @return {@link List}<{@link CalEqvaIncomeVO}>
     */
    List<CalEqvaIncomeVO> queryListDynamic(CalEqvaIncomeQuery query);

    /**
     * 通过主键查询
     *
     * @param key 主键
     * @return {@link CalEqvaIncomeVO}
     */
    CalEqvaIncomeVO queryByKey(Long key);

    /**
     * 新增或修改
     *
     * @param payload 单据数据
     * @return {@link CalEqvaIncomeVO}
     */
    CalEqvaIncomeVO insertOrUpdate(CalEqvaIncomePayload payload);


    /**
     * 逻辑删除
     *
     * @param keys 主键集合
     */
    void deleteSoft(List<Long> keys);

    /**
     * 精准匹配查询-获取价格
     *
     * @param query
     * @return
     */
    CalEqvaIncomeVO getEqvaSalary(CalEqvaIncomeQuery query);

    /**
     * 查询外部资源当量价格配置
     *
     * @param userId
     * @return
     */
    CalEqvaIncomeVO queryExternalEqvaIncome(Long userId);

    /**
     * 保存外部资源当量价格配置
     *
     * @param payload
     * @return
     */
    CalEqvaIncomeVO saveExterEqvaIncome(CalEqvaIncomePayload payload);
}
