package com.elitesland.tw.tw5.api.prd.copartner.service;

import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.tw.tw5.api.prd.copartner.payload.PerformanceReadmeConfigPayload;
import com.elitesland.tw.tw5.api.prd.copartner.query.PerformanceReadmeConfigQuery;
import com.elitesland.tw.tw5.api.prd.copartner.vo.PerformanceReadmeConfigVO;
import com.elitesland.workflow.payload.ProcessStatusChangePayload;

import java.util.List;

/**
 * 合伙人绩效自述配置
 *
 * @author carl
 * @date 2024-06-24
 */
public interface PerformanceReadmeConfigService {

    /**
     * 分页列表
     *
     * @param query 条件
     * @return {@link PagingVO}<{@link PerformanceReadmeConfigVO}>
     */
    PagingVO<PerformanceReadmeConfigVO> queryPaging(PerformanceReadmeConfigQuery query);

    /**
     * 查询列表
     *
     * @param query 条件参数
     * @return {@link List}<{@link PerformanceReadmeConfigVO}>
     */
    List<PerformanceReadmeConfigVO> queryListDynamic(PerformanceReadmeConfigQuery query);

    /**
     * 通过主键查询
     *
     * @param key 主键
     * @return {@link PerformanceReadmeConfigVO}
     */
    PerformanceReadmeConfigVO queryByKey(Long key);

    /**
     * 新增
     *
     * @param payload 单据数据
     * @return {@link PerformanceReadmeConfigVO}
     */
    PerformanceReadmeConfigVO insertOrUpdate(PerformanceReadmeConfigPayload payload);

    /**
     * 修改
     *
     * @param payload 单据数据
     * @return {@link PerformanceReadmeConfigVO}
     */
    PerformanceReadmeConfigVO update(PerformanceReadmeConfigPayload payload);

    /**
     * 修改,置空的字段需需要借助 protected List<String> nullFields;
     *
     * @param payload 单据数据
     * @return {@link long}
     */
    long updateByKeyDynamic(PerformanceReadmeConfigPayload payload);

    /**
     * 逻辑删除
     *
     * @param keys 主键集合
     */
    void deleteSoft(List<Long> keys);

    /**
     * 发起考核
     *
     * @param key
     */
    void startAssessment(Long key);

    void processStatusChange(ProcessStatusChangePayload payload);
}
