package com.elitesland.tw.tw5.api.prd.crm.payload;

import com.elitesland.tw.tw5.api.common.TwCommonPayload;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import org.springframework.format.annotation.DateTimeFormat;

import java.math.BigDecimal;
import java.time.LocalDate;

/**
 * @Author carl.wang
 * @Description 商机表
 * @Date
 **/

@Data

public class CrmOpportunityPayload extends TwCommonPayload {
    private Long projectId;
    /**
     * 项目名称（商机名称）
     */
    private String projectName;
    /**
     * 项目编号（商机编号）
     */
    private String projectNo;

    /**
     * 易稻壳对应itemId
     */
    private String itemId;
    /**
     * 活动id
     */
    private Long actId;
    /**
     * 签单负责人id
     */
    private Long manageUserId;
    /**
     * 签单buid
     */
    private Long orgId;
    /**
     * 公司id
     */
    private Long companyId;
    /**
     * 附件地址codes（“，”分割字符串）
     */
    private String fileCodes;

    /**
     * 项目状态
     */
    private String projectStatus;

    /**
     * 关闭原因
     */
    private String closeReason;
    /**
     * 丢单原因
     */
    private String loseReason;

    /**
     * 关闭备注
     */
    private String clsoeRemark;

    /**
     * 线索id
     */
    private Long leadsId;
    /**
     * 销售产品
     */
    private String saleProduct;
    /**
     * 客户区域
     */
    private String custRegion;
    /**
     * 是否老客户 0:Y,1:N
     */
    private Integer isOldCust;
    /**
     * 客户id 老客户才会选择
     */
    private Long custBookId;
    /**
     * 客户名称
     */
    private String custBookName;
    /**
     * 客户项目
     */
    private String custProject;
    /**
     * 客户联系人
     */
    private String contactName;
    /**
     * 客户联系电话
     */
    private String contactPhone;
    /**
     * 客户联系人部门
     */
    private String contactDept;
    /**
     * 客户联系人岗位
     */
    private String contactPosition;
    /**
     * 企业主页
     */
    private String contactWebsite;
    /**
     * 客户性质
     */
    private String custProp;
    /**
     * 客户行业
     */
    private String custIdst;
    /**
     * 预计成单日期
     */
    @DateTimeFormat(pattern = "yyyy-MM-dd")
    private LocalDate forecastWinDate;
    /**
     * 预计签单金额
     */
    private BigDecimal forecastAmount;
    /**
     * 成单概率
     */
    private String probability;
    /**
     * 成单概率不清楚原因
     */
    private String probabilityHint;
    /**
     * 币种
     */
    private String currCode;
    /**
     * 销售阶段
     */
    private String salePhase;
    /**
     * 交付地点
     */
    private String deliveryAddress;
    /**
     * 商机级别
     */
    private String oppoLevel;
    /**
     * 是否需要合作伙伴 0:Y,1:N
     */
    private Integer isNeedPartner;
    /**
     * 关联合作伙伴Id
     */
    private Long coopBookId;
    /**
     * 关联合作伙伴名称
     */
    private String coopBookName;
    /**
     * 合作伙伴描述
     */
    private String partnerDesc;
    /**
     * 售前bu
     */
    private Long preSaleOrgId;
    /**
     * 售前负责人
     */
    private Long preSaleUserId;
    /**
     * 项目难度
     */
    private String projectDifficult;
    /**
     * 项目重要度
     */
    private String projectImportance;
    /**
     * 交付BU_ID
     */
    private Long deliOrgId;
    /**
     * 交付负责人ID
     */
    private Long deliUserId;
    /**
     * 方案难度
     */
    private String solutionDifficulty;
    /**
     * 方案重要度
     */
    private String solutionImportance;
    /**
     * 合作(副)签单BU_ID
     */
    private Long coOrgId;
    /**
     * 合作(副)签单负责人ID
     */
    private Long coUserId;
    /**
     * 合作(副)交付BU_ID
     */
    private Long codeliOrgId;
    /**
     * 合作(副)交付负责人ID
     */
    private Long codeliUserId;
    /**
     * 来源类型
     */
    private String sourceType;
    /**
     * 内部来源BU_ID
     */
    private Long internalOrgId;
    /**
     * 内部来源人ID
     */
    private Long internalUserId;
    /**
     * 外部线索来源
     */
    private String externalIden;
    /**
     * 外部来源人
     */
    private String externalName;
    /**
     * 外部来源电话
     */
    private String externalPhone;
    /**
     * 利益承诺
     */
    private String profitDesc;

    /**
     * 关联正式客户id
     */
    private Long formalCustomerId;

    private String extString1;
    private String extString2;
    private String extString3;
    private String extString4;
    private String extString5;


    //4.0相关字段============================

    private Long oppoIdV4;

    private Long custBookIdV4;

    private Long orgIdV4;//签单buId

    private Long manageUserIdV4;//签单负责人

    private Long coOrgIdV4;

    private Long coUserIdV4;

    private Long deliOrgIdV4;

    private Long deliUserIdV4;

    private Long codeliOrgIdV4;

    private Long codeliUserIdV4;

    private Long internalOrgIdV4;

    private Long internalUserIdV4;

    private Long preSaleOrgIdV4;

    private Long preSaleUserIdV4;


    /**
     * 验证状态
     */
    private String checkStatus;

    //======补充字段=======
    /**
     * 是否实施过本公司产品
     */
    private Long isImplementation;
    /**
     * 实施情况
     */
    private String implementCondition;
    /**
     * 上线要求
     */
    private String onboarding;
    /**
     * 项目预算情况
     */
    private String proResource;
    /**
     * 项目发起原因
     */
    private String proInitiateReason;
    /**
     * 项目关键决策人描述
     */
    private String proPolicymakerDesc;
    /**
     * 接触部门描述
     */
    private String contactBUDesc;
    /**
     * 涉及本公司产品与服务
     */
    private String productServe;
    /**
     * 对标客户
     */
    private String benchmarkingCust;
    /**
     * 客户年营业额（万元）
     */
    private String custTurnoverYear;
    /**
     * 是否是上市公司
     */
    private Long isListedCompany;
    /**
     * 方案情况(UDC)
     */
    private String programSituation;
    /**
     * 团队资源(UDC)
     */
    private String teamResources;
    /**
     * 商务资源(UDC)
     */
    private String businessResources;
    /**
     * 副售前负责人
     */
    private Long codePreSaleUserId;
    /**
     * 当量预估单价
     */
    @ApiModelProperty("当量预估单价")
    private BigDecimal eqvaPrice;

    @ApiModelProperty("上级主管部门")
    private String parentManageBU;
}
