package com.elitesland.tw.tw5.api.prd.crm.payload;

import com.alibaba.excel.annotation.ExcelIgnoreUnannotated;
import com.alibaba.excel.annotation.ExcelProperty;
import com.elitesland.tw.tw5.api.prd.prj.payload.PrjProjectPayload;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import org.springframework.format.annotation.DateTimeFormat;

import java.time.LocalDateTime;
import java.util.List;

/**
 * @author zoey
 * @Description:潜在客户表
 * @date 2022/5/17 - 14:13
 */
@Data
@ExcelIgnoreUnannotated
public class CrmPotentialCustomerPayload {

    @ApiModelProperty("主键")
    private Long id;

    /**
     * 备注
     */
    @ApiModelProperty("备注")
    @ExcelProperty(index = 14)
    private String remark;

    @ApiModelProperty("创建者用户ID")
    private Long createUserId;

    /**
     * 创建时间
     */
    @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    @ApiModelProperty("创建时间")
    private LocalDateTime createTime;
    /**
     * 创建时间
     */
    @ExcelProperty(index = 13)
    private String createTimeStr;


    @ApiModelProperty("修改者用户ID")
    private Long modifyUserId;

    @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    @ApiModelProperty("修改时间起")
    private LocalDateTime modifyTime;

    @ApiModelProperty("删除标识（0：未删除，1：已删除）")
    private Integer deleteFlag;

    @ApiModelProperty("忽视警告")
    protected boolean ignoreWarning;

    @ApiModelProperty("需要设置成null值的属性")
    protected List<String> nullFields;

    @ApiModelProperty("变更日志的id")
    protected Long changeLogId;

    /**
     * 公海
     **/
    private CrmOpenseaPayload opensea;


    /**
     * 市场活动
     **/
    private PrjProjectPayload market;

    /**
     * 公海id
     */
    @ExcelProperty(index = 25)
    private Long openseaId;
    /**
     * 公海名称
     */
    @ExcelProperty(index = 1)
    private String openseaName;

//    /**
//     * 新公海id
//     **/
//    private Long newOpenseaId;

    /**
     * 市场活动id
     */
    @ExcelProperty(index = 26)
    private Long marketId;
    /**
     * 市场活动
     */
    @ExcelProperty(index = 2)
    private String marketIdDesc;//仅导入时用

    /**
     * 客户名称
     */
    @ExcelProperty(index = 3)
    private String customerName;

    /**
     * 客户编号
     **/
    private String customerNo;

    /**
     * 客户状态
     **/
    private String customerStatus;

    /**
     * 客户级别
     **/
    @ExcelProperty(index = 27)
    private String customerGrade;
    @ExcelProperty(index = 4)
    private String customerGradeDesc;

    /**
     * 客户行业编号
     */
    @ExcelProperty(index = 28)
    private String customerIndustry;
    /**
     * 客户行业
     */
    @ExcelProperty(index = 5)
    private String customerIndustryDesc;

    /**
     * 联系人姓名
     **/
    @ExcelProperty(index = 6)
    private String customerContacts;

    /**
     * 客户电话
     **/
    @ExcelProperty(index = 7)
    private String customerPhone;

    /**
     * 客户邮箱
     **/
    @ExcelProperty(index = 8)
    private String customerEmail;

    /**
     * 客户地址-省
     **/
    private String customerLocationProvince;

    /**
     * 客户地址-市
     **/
    private String customerLocationCity;

    /**
     * 客户地址-区
     **/
    private String customerLocationDistrict;

    /**
     * 详细地址
     **/
    @ExcelProperty(index = 12)
    private String customerLocationDetail;



    /**
     * 省
     **/
//    @ExcelProperty(index = 9)
    private String customerLocationProvinceName;

    /**
     * 市
     **/
    @ExcelProperty(index = 10)
    private String customerLocationCityName;

    /**
     * 区
     **/
//    @ExcelProperty(index = 11)
    private String customerLocationDistrictName;

    /**
     * 转移原因
     */
    private String transferReason;

    /**
     * 标签id
     */
    private String tagIds;

    /**
     * 需求产品
     */
    private String demandProduct;

    /**
     * 导入警告
     */
    private String importWarn;

    /**
     * 导入错误
     */
    private String imoprtError;


    /**
     * 客户区域
     */
    @ExcelProperty(index = 29)
    private String custRegion;

    /**
     * 市场渠道
     */
    @ExcelProperty(index = 30)
    private String marketChannel;

    /**
     * 联系人部门
     */
    @ExcelProperty(index = 15)
    private String contactsDepartment;

    /**
     * 联系人岗位
     */
    @ExcelProperty(index = 16)
    private String contactsPosition;


}
