package com.elitesland.tw.tw5.api.prd.crm.service;

import com.elitesland.tw.tw5.api.prd.crm.payload.CrmCustomerOperationEmployeesPayload;
import com.elitesland.tw.tw5.api.prd.crm.query.CrmCustomerOperationEmployeesQuery;
import com.elitesland.tw.tw5.api.prd.crm.vo.CrmCustomerOperationEmployeesVO;
import com.elitescloud.cloudt.common.base.PagingVO;

import javax.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.util.List;

/**
* 客户经营-企业工商主要人员
*
* @author duwh
* @date 2022-12-06
*/
public interface CrmCustomerOperationEmployeesService {

    /**
    * 分页列表
    *
    * @param query 条件
    * @return {@link PagingVO}<{@link CrmCustomerOperationEmployeesVO}>
    */
    PagingVO<CrmCustomerOperationEmployeesVO> paging(CrmCustomerOperationEmployeesQuery query);

    /**
    * 查询列表
    *
    * @param query 条件参数
    * @return {@link List}<{@link CrmCustomerOperationEmployeesVO}>
    */
    List<CrmCustomerOperationEmployeesVO> queryList(CrmCustomerOperationEmployeesQuery query);

    /**
     * 通过主键查询
     *
     * @param key 主键
     * @return {@link CrmCustomerOperationEmployeesVO}
     */
    CrmCustomerOperationEmployeesVO queryByKey(Long key);

    /**
    * 新增
    *
    * @param payload 单据数据
    * @return {@link CrmCustomerOperationEmployeesVO}
    */
    CrmCustomerOperationEmployeesVO insert(CrmCustomerOperationEmployeesPayload payload);

    /**
    * 修改
    *
    * @param payload 单据数据
    * @return {@link CrmCustomerOperationEmployeesVO}
    */
    CrmCustomerOperationEmployeesVO update(CrmCustomerOperationEmployeesPayload payload);

    /**
    * 逻辑删除
    *
    * @param keys 主键集合
    */
    void deleteSoft(List<Long> keys);

    /**
    * Excel导出数据
    *
    * @param all 待导出的数据
    * @param response /
    * @throws IOException /
    */
    void download(List<CrmCustomerOperationEmployeesVO> all, HttpServletResponse response) throws IOException;
}
