package com.elitesland.tw.tw5.api.prd.humanresources.payload;

import lombok.Data;
import io.swagger.annotations.ApiModelProperty;
import io.swagger.annotations.ApiModel;

import java.math.BigDecimal;
import java.time.LocalDateTime;
import java.time.LocalDate;

import com.elitesland.tw.tw5.api.common.TwCommonPayload;


/**
 * @author : WWW
 * @date : 2023-11-24
 * @desc : 评价配置点表
 */

@Data
@ApiModel(description = "评价配置点表")
public class PrdEvaluateConfigPointPayload extends TwCommonPayload {


    /**
     * 名称
     */
    @ApiModelProperty("名称")
    private String name;

    /**
     * 状态
     */
    @ApiModelProperty("状态")
    private Integer state;

    /**
     * 分数下限
     */
    @ApiModelProperty("分数下限")
    private BigDecimal scoreMin;

    /**
     * 分数上限
     */
    @ApiModelProperty("分数上限")
    private BigDecimal scoreMax;

    /**
     * 默认分数
     */
    @ApiModelProperty("默认分数")
    private BigDecimal defScore;

    /**
     * 标准说明
     */
    @ApiModelProperty("标准说明")
    private String standardDesc;


}

