package com.elitesland.tw.tw5.api.prd.my.payload;

import com.elitesland.tw.tw5.api.common.TwCommonPayload;
import io.swagger.annotations.ApiModelProperty;
import lombok.Getter;
import lombok.Setter;

import java.io.Serializable;
import java.time.LocalDate;

@Getter
@Setter
public class TAttendanceNormalPayload extends TwCommonPayload implements Serializable {
    /**
     * 打卡人员ID
     */
    @ApiModelProperty("打卡人员ID")
    private Long attendanceResId;
    /**
     * 打卡日期
     */
    @ApiModelProperty("打卡日期")
    private LocalDate attendanceDate;
    /**
     * 规则ID
     */
    @ApiModelProperty("规则ID")
    private Long attendanceRuleId;
    /**
     * 上班时间
     */
    @ApiModelProperty("上班时间")
    private String attendanceTimeStart;
    /**
     * 下班时间
     */
    @ApiModelProperty("下班时间")
    private String attendanceTimeEnd;


    @ApiModelProperty("打卡经度")
    private String attendanceSiteLongitude;

    @ApiModelProperty("打卡纬度")
    private String attendanceSiteLatitude;

    @ApiModelProperty("打卡位置")
    private String attendanceLocation;

    @ApiModelProperty("打卡城市")
    private String attendanceCity;

    /**
     * 打卡结果 YSE/NO
     */
    @ApiModelProperty("打卡结果 YSE/NO")
    private String attendanceResult;
    /**
     * 正常、迟到或早退、矿工
     */
    @ApiModelProperty("正常、迟到或早退、矿工")
    private String attendanceResultDetail;
    /**
     * 特殊打卡原因
     */
    @ApiModelProperty("特殊打卡原因")
    private String specialReason;
    /**
     * 打卡设备
     */
    @ApiModelProperty("打卡设备")
    private String attendanceDevice;
}

