package com.elitesland.tw.tw5.api.prd.partner.business.service;

import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.tw.tw5.api.prd.partner.business.payload.BusinessOperationPartnerPayload;
import com.elitesland.tw.tw5.api.prd.partner.business.query.BusinessOperationPartnerQuery;
import com.elitesland.tw.tw5.api.prd.partner.business.vo.BusinessOperationPartnerVO;

import java.util.List;

/**
 * 业务伙伴-工商股东
 *
 * @author wangly
 * @date 2023-05-16
 */
public interface BusinessOperationPartnerService {

    /**
     * 分页列表
     *
     * @param query 条件
     * @return {@link PagingVO}<{@link BusinessOperationPartnerVO}>
     */
    PagingVO<BusinessOperationPartnerVO> queryPaging(BusinessOperationPartnerQuery query);

    /**
     * 查询列表
     *
     * @param query 条件参数
     * @return {@link List}<{@link BusinessOperationPartnerVO}>
     */
    List<BusinessOperationPartnerVO> queryListDynamic(BusinessOperationPartnerQuery query);

    /**
     * 通过主键查询
     *
     * @param key 主键
     * @return {@link BusinessOperationPartnerVO}
     */
    BusinessOperationPartnerVO queryByKey(Long key);

    /**
     * 新增
     *
     * @param payload 单据数据
     * @return {@link BusinessOperationPartnerVO}
     */
    BusinessOperationPartnerVO insert(BusinessOperationPartnerPayload payload);

    /**
     * 修改
     *
     * @param payload 单据数据
     * @return {@link BusinessOperationPartnerVO}
     */
    BusinessOperationPartnerVO update(BusinessOperationPartnerPayload payload);

    /**
     * 逻辑删除
     *
     * @param keys 主键集合
     */
    void deleteSoft(List<Long> keys);

    /**
     * 通过partnerId删除
     *
     * @param partnerId 业务伙伴id
     */
    void deleteByPartnerId(Long partnerId);
}
