package com.elitesland.tw.tw5.api.prd.partner.business.vo;

import com.elitescloud.boot.common.param.BaseViewModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Getter;
import lombok.Setter;

import java.io.Serializable;


/**
  * 业务合作伙伴-工商股东
  *
  * @author wangly
  * @date 2023-05-18
  */
@Getter
@Setter
public class BusinessOperationPartnerVO extends BaseViewModel implements Serializable {
    /** 地址簿id */
    @ApiModelProperty("地址簿id")
    private Long bookId;
    /** 总实缴 */
    @ApiModelProperty("总实缴")
    private String totalRealCapi;
    /** 出资时间 */
    @ApiModelProperty("出资时间")
    private String date;
    /** 历史股东 */
    @ApiModelProperty("历史股东")
    private String isHstory;
    /** 股东类型 */
    @ApiModelProperty("股东类型")
    private String stockType;
    /** 股东姓名 */
    @ApiModelProperty("股东姓名")
    private String name;
    /** 人员id（股东为自然人显示pid） */
    @ApiModelProperty("人员id（股东为自然人显示pid）")
    private String pid;
    /** 认缴出资列表 */
    @ApiModelProperty("认缴出资列表")
    private String shouldcapiitems;
    /** 总认缴 */
    @ApiModelProperty("总认缴")
    private String totalShouldCapi;
    /** 股比 */
    @ApiModelProperty("股比")
    private String stockPercent;
    /** 企业id（股东为企业显示eid） */
    @ApiModelProperty("企业id（股东为企业显示eid）")
    private String eid;
    /** 类型 */
    @ApiModelProperty("类型")
    private String identifyType;
    /** 认缴出资额 */
    @ApiModelProperty("认缴出资额")
    private String capi;
    /** 股东ID */
    @ApiModelProperty("股东ID")
    private String identifyNo;
    /** 实缴出资列表 */
    @ApiModelProperty("实缴出资列表")
    private String realCapiItems;
    /** 出资方式 */
    @ApiModelProperty("出资方式")
    private String type;
    /** 业务伙伴主键 business_partner.id */
    @ApiModelProperty("业务伙伴主键 business_partner.id")
    private Long partnerId;
    /** 业务伙伴名称 */
    @ApiModelProperty("业务伙伴名称")
    private String partnerName;
}
