package com.elitesland.tw.tw5.api.prd.partner.identity.vo;

import com.elitescloud.boot.common.param.BaseViewModel;
import com.elitescloud.cloudt.common.annotation.Comment;
import com.elitesland.tw.tw5.api.prd.partner.common.vo.BookContactsVO;
import com.elitesland.tw.tw5.api.udc.UdcName;
import io.swagger.annotations.ApiModelProperty;
import lombok.Getter;
import lombok.Setter;

import javax.persistence.Column;

@Getter
@Setter
public class BusinessCustomerSimpleVO extends BaseViewModel {
    /**
     * 地址簿Id
     */
    @ApiModelProperty("地址簿Id")

    private Long bookId;

    /**
     * 业务伙伴编号
     */
    @ApiModelProperty("业务伙伴编号")

    private String businessPartnerNo;

    /**
     * 客户名称
     */
    @ApiModelProperty("客户名称")
    private String customerName;
    /**
     * 税号
     */
    @ApiModelProperty("税号")
    private String taxNo;
    /**
     * 银行
     */
    @ApiModelProperty("银行")
    private String depositBank;
    /**
     * 账号
     */
    @ApiModelProperty("账号")
    private String accountNo;
    /**
     * 开票地址
     */
    @ApiModelProperty("开票地址")
    private String invoiceAddress;

    /**
     * 电话
     */
    @ApiModelProperty("电话")
    private String invoicePhone;
    /**
     * 公司行业
     */
    @ApiModelProperty("公司行业")
    private String companyIndustry;
    /**
     * 公司行业
     */
    @ApiModelProperty("公司行业")
    @UdcName(udcName = "crm:leads_customer_industry", codePropName = "companyIndustry")
    private String companyIndustryName;

//    /**
//     * 地址信息
//     */
//    @ApiModelProperty("地址信息")
//    private List<PrdAbAddressVO> prdAbAddressVOs;

    /**
     * 经纬度
     */
    @ApiModelProperty("经纬度")
    private String longitudeLatitude;

    /**
     * 业务伙伴主键 business_partner.id
     */
    @ApiModelProperty("业务伙伴主键 business_partner.id")
    private Long partnerId;

    private String ext4;

    private String ext5;

    /**
     * 排序号
     */
    private Integer sortNo;


    /**
     * 供应商状态
     */
    @ApiModelProperty("供应商状态")
    private String supplierStatus;


    /**
     * 联系人信息
     */
    @ApiModelProperty("联系人信息")
    private BookContactsVO bookContactsVO;

    /** 性质 udc[crm:company_nature] */
    @ApiModelProperty("性质 udc[crm:company_nature]")
    private String partnerNature;

    /** 性质 udc[crm:company_nature] */
    @ApiModelProperty("性质描述 udc[crm:company_nature]")
    @UdcName(udcName = "crm:company_nature",codePropName = "partnerNature")
    private String partnerNatureDesc;

    /** 业务伙伴区域 */
    @ApiModelProperty("业务伙伴区域 udc[crm:customer_region]")
    private String partnerRegion;

    /** 业务伙伴区域 */
    @ApiModelProperty("业务伙伴区域 udc[crm:customer_region]")
    @UdcName(udcName="crm:customer_region",codePropName = "partnerRegion")
    private String partnerRegionDesc;


    @ApiModelProperty("上级主管部门")
    private String parentManageBU;
}
