package com.elitesland.tw.tw5.api.prd.pms.payload;

import com.elitesland.tw.tw5.api.common.TwCommonPayload;
import com.elitesland.tw.tw5.api.udc.UdcName;
import com.elitesland.workflow.enums.ProcInstStatus;
import io.swagger.annotations.ApiModelProperty;
import lombok.Getter;
import lombok.Setter;
import java.io.Serializable;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.util.List;

/**
 * 派发
 *
 * @author xxb
 * @date 2023-08-07
 */
@Getter
@Setter
public class PmsDistributePayload extends TwCommonPayload  implements Serializable {
    /** 派发类型 */
    @ApiModelProperty("派发类型")
    private String reasonType;
    /** 派发事由ID */
    @ApiModelProperty("派发事由ID")
    private Long reasonId;
    /** 派发事由 */
    @ApiModelProperty("派发事由")
    private String reasonName;
    /** 派发编号 */
    @ApiModelProperty("派发编号")
    private String distNo;
    /** 派发资源ID */
    @ApiModelProperty("派发资源ID")
    private Long disterResId;
    @ApiModelProperty("派发资源姓名")
    private String disterResName;
    /** 接收资源ID */
    @ApiModelProperty("接收资源ID")
    private Long receiverResId;
    @ApiModelProperty("接收资源姓名")
    private String receiverResName;
    /** 派发状态 */
    @ApiModelProperty("派发状态")
    private String distStatus;
    /** 审批状态 */
    @ApiModelProperty("审批状态")
    private String apprStatus;
    /** 派发方式 */
    @ApiModelProperty("派发方式")
    private String distMethod;
    /** 派发说明 */
    @ApiModelProperty("派发说明")
    private String distDesc;
    /** 复合能力ID */
    @ApiModelProperty("复合能力ID")
    private Long capasetLevelId;
    @ApiModelProperty("单项能力")
    private String capaIds;
    /** 预计开始日期 */
    @ApiModelProperty("预计开始日期")
    private LocalDate planStartDate;
    /** 预计结束日期 */
    @ApiModelProperty("预计结束日期")
    private LocalDate planEndDate;

    @ApiModelProperty("工作地国家")
    private String workCountry;

    @ApiModelProperty("工作地省")
    private String workProvince;

    @ApiModelProperty("现场远程")
    private String workStyle;

    @ApiModelProperty("时间要求")
    private String timeRequirement;

    @ApiModelProperty("兼职|全职")
    private String workMethod;

    @ApiModelProperty("工作地")
    private String workPlace;

    @ApiModelProperty("最低信用级别")
    private String minSecurityLevel;


    /** 应答人数上限 */
    @ApiModelProperty("应答人数上限")
    private Long respNumber;
    /** 广播天数 */
    @ApiModelProperty("广播天数")
    private Long broadcastDays;


    /**
     * 流程定义KEY
     */
    private String procDefKey;

    @ApiModelProperty("流程实例ID")
    private String procInstId;

    @ApiModelProperty("流程审批状态")
    private ProcInstStatus procInstStatus;

    @ApiModelProperty("提交时间")
    private LocalDateTime submitTime;

    @ApiModelProperty("审批时间")
    private LocalDateTime approvedTime;

    @ApiModelProperty("响应列表")
    private List<PmsDistributeRespondPayload> respondPayloads;

    @ApiModelProperty("广播信息")
    private PmsDistBroadcastPayload broadcastPayload;
}
