package com.elitesland.tw.tw5.api.prd.pms.query;

import com.elitesland.tw.tw5.api.common.TwQueryParam;
import io.swagger.annotations.ApiModelProperty;
import lombok.Getter;
import lombok.Setter;

import java.io.Serializable;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.util.List;

/**
 * 项目汇报计划管理
 *
 * @author carl
 * @date 2023-09-05
 */
@Getter
@Setter
public class PmsProjectReportPlanQuery extends TwQueryParam implements Serializable {
    /**
     * 记录唯一ID 精确
     */
    @ApiModelProperty("记录唯一ID")
    private Long id;
    /**
     * 项目id 精确
     */
    @ApiModelProperty("项目id")
    private Long projId;
    /**
     * 项目ids 精确
     */
    @ApiModelProperty("项目ids")
    private List<Long> projIds;

    /**
     * 期间 精确
     */
    @ApiModelProperty("期间")
    private LocalDate periodDate;
    /**
     * 金额 精确
     */
    @ApiModelProperty("金额")
    private BigDecimal amt;
    /**
     * 项目汇报id 精确
     */
    @ApiModelProperty("项目汇报id")
    private Long briefId;
    /**
     * 开始时间
     */
    @ApiModelProperty("开始时间")
    private LocalDate startDate;
    /**
     * 结束时间
     */
    @ApiModelProperty("结束时间")
    private LocalDate endDate;
}
