package com.elitesland.tw.tw5.api.prd.salecon.service;

import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.tw.tw5.api.prd.salecon.payload.ConReceivablePlanPayload;
import com.elitesland.tw.tw5.api.prd.salecon.payload.ConReceivablePlanSavePayload;
import com.elitesland.tw.tw5.api.prd.salecon.payload.ConRecvplanChangeLogPayload;
import com.elitesland.tw.tw5.api.prd.salecon.query.ConReceivablePlanQuery;
import com.elitesland.tw.tw5.api.prd.salecon.vo.ConReceivablePlanDataVO;
import com.elitesland.tw.tw5.api.prd.salecon.vo.ConReceivablePlanVO;
import com.elitesland.tw.tw5.api.prd.salecon.vo.ContractNodeVO;
import org.springframework.web.multipart.MultipartFile;

import javax.servlet.http.HttpServletResponse;
import java.time.LocalDate;
import java.util.List;
import java.util.Map;

/**
 * 收款计划
 *
 * @author likunpeng
 * @date 2023-03-29
 */
public interface ConReceivablePlanService {

    /**
     * 分页列表
     *
     * @param query 条件
     * @return {@link PagingVO}<{@link ConReceivablePlanVO}>
     */
    PagingVO<ConReceivablePlanVO> paging(ConReceivablePlanQuery query);

    /**
     * 分页列表
     *
     * @param query 条件
     * @return {@link PagingVO}<{@link ConReceivablePlanVO}>
     */
    PagingVO<ConReceivablePlanVO> queryPaging(ConReceivablePlanQuery query);

    /**
     * 查询列表
     *
     * @param query 条件参数
     * @return {@link List}<{@link ConReceivablePlanVO}>
     */
    List<ConReceivablePlanVO> queryList(ConReceivablePlanQuery query);

    /**
     * 查询列表
     *
     * @param query 条件参数
     * @return {@link List}<{@link ConReceivablePlanVO}>
     */
    List<ConReceivablePlanVO> queryListDynamic(ConReceivablePlanQuery query);

    /**
     * 查询列表
     *
     * @param query 条件参数
     * @return {@link List}<{@link ConReceivablePlanVO}>
     */
    Long countListDynamic(ConReceivablePlanQuery query);

    /**
     * 通过主键查询
     *
     * @param key 主键
     * @return {@link ConReceivablePlanVO}
     */
    ConReceivablePlanVO queryByKey(Long key);

    /**
     * 新增
     *
     * @param payload 单据数据
     * @return {@link ConReceivablePlanVO}
     */
    ConReceivablePlanVO insert(ConReceivablePlanPayload payload);

    int saveContractRecvPlans(ConReceivablePlanSavePayload payload);

    /**
     * 新增多条
     *
     * @param payloadList
     * @return
     */
    List<ConReceivablePlanVO> insertAll(List<ConReceivablePlanPayload> payloadList);

    /**
     * 修改
     *
     * @param payload 单据数据
     * @return {@link ConReceivablePlanVO}
     */
    ConReceivablePlanVO update(ConReceivablePlanPayload payload);

    /**
     * 逻辑删除
     *
     * @param keys 主键集合
     */
    void deleteSoft(List<Long> keys);

    /**
     * 根据合同ID查询收款计划
     *
     * @param saleConId
     * @return {@link List<ConReceivablePlanVO>}
     */
    List<ConReceivablePlanVO> queryBySaleConId(Long saleConId);

    PagingVO<ConReceivablePlanVO> queryBySaleConId(Long saleConId, ConReceivablePlanQuery query);


    void batchReceivablePlanExport(HttpServletResponse response, ConReceivablePlanQuery query);

    void downloadBatch(HttpServletResponse response, ConReceivablePlanQuery query);

    Map<String, Object> importBatchPro(MultipartFile file, Boolean force, Long saleConId) throws InterruptedException;

    @Deprecated
    void syncContractRecvplanTo4(String param);

    void invalidRecvplan(List<Long> ids, String remark);

    Boolean updateRecvOrInvDate(ConRecvplanChangeLogPayload payload);

    /**
     * 批量更新预计收款日期
     *
     * @param updateData
     */
    void updateExpectReceDate(Map<Long, String> updateData);

    /**
     * 根据合同Id查询约束合同节点
     *
     * @param saleConId 合同Id
     */
    List<ContractNodeVO> findConNodeByConId(Long saleConId);


    /**
     * 查询我的收款和开票数量
     *
     * @param type 类型 （1.我的收款，2.我的开票）
     * @return 处理条数
     */
//    Integer taskPrdConPrompt();

    ConReceivablePlanDataVO queryAppMyHandlNum(String type);
}
