package com.elitesland.tw.tw5.api.prd.salecon.service;

import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.tw.tw5.api.prd.salecon.payload.SaleConExecConditionPayload;
import com.elitesland.tw.tw5.api.prd.salecon.query.SaleConExecConditionQuery;
import com.elitesland.tw.tw5.api.prd.salecon.vo.SaleConContractVO;
import com.elitesland.tw.tw5.api.prd.salecon.vo.SaleConExecConditionVO;

import java.math.BigDecimal;
import java.util.List;

/**
 * 销售合同执行情况管理
 *
 * @author sunxw
 * @date 2023-11-24
 */
public interface SaleConExecConditionService {

    /**
     * 分页列表
     *
     * @param query 条件
     * @return {@link PagingVO}<{@link SaleConExecConditionVO}>
     */
    PagingVO<SaleConExecConditionVO> queryPaging(SaleConExecConditionQuery query);

    /**
     * 查询列表
     *
     * @param query 条件参数
     * @return {@link List}<{@link SaleConExecConditionVO}>
     */
    List<SaleConExecConditionVO> queryListDynamic(SaleConExecConditionQuery query);

    /**
     * 通过主键查询
     *
     * @param key 主键
     * @return {@link SaleConExecConditionVO}
     */
    SaleConExecConditionVO queryByKey(Long key);

    /**
     * 新增
     *
     * @param payload 单据数据
     * @return {@link SaleConExecConditionVO}
     */
    SaleConExecConditionVO insertOrUpdate(SaleConExecConditionPayload payload);

    /**
     * 修改
     *
     * @param payload 单据数据
     * @return {@link SaleConExecConditionVO}
     */
    SaleConExecConditionVO update(SaleConExecConditionPayload payload);

    /**
     * 修改,置空的字段需需要借助 protected List<String> nullFields;
     *
     * @param payload 单据数据
     * @return {@link long}
     */
    long updateByKeyDynamic(SaleConExecConditionPayload payload);

    /**
     * 逻辑删除
     *
     * @param keys 主键集合
     */
    void deleteSoft(List<Long> keys);

    /**
     * 构建合同执行情况
     *
     * @param payload
     * @return
     */
    SaleConExecConditionPayload buildConExecCondition(SaleConExecConditionPayload payload);

    /**
     * 根据合同ID查询详情
     *
     * @param contractId
     * @return
     */
    SaleConExecConditionVO queryByContractId(Long contractId);

    /**
     * 计算核算后有效额
     *
     * @param payload
     * @return
     */
    BigDecimal calcEffectAmt(SaleConExecConditionPayload payload);

    /**
     * 合同预算提交审批
     *
     * @param  vo
     * @return
     */
    void saleConExecConditionApply(SaleConExecConditionVO vo, SaleConContractVO saleConContractVO);

    /**
     * 查询合同预算工作代办的数据
     *
     * @param
     * @return
     */
    PagingVO<SaleConExecConditionVO> queryWorkAgentFlagPaging(SaleConExecConditionQuery query);

    /**
     * 查询合同预算工作代办的条数
     *
     * @param
     * @return
     */
    Long queryWorkAgentFlagCount(Long userId);
}
