package com.elitesland.tw.tw5.api.prd.system.payload;

import com.elitesland.tw.tw5.api.common.TwCommonPayload;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

import java.util.List;

/**
 * 业务对象 功能列表
 * @Author Bill
 * @Date 2023/9/18 13:20
 **/
@Data
@EqualsAndHashCode(callSuper = true)
@Accessors(chain = true)
public class PrdSystemNewFunctionPayload extends TwCommonPayload {

    /**
     * 功能编号
     */
    private String functionCode;

    /**
     * 功能名称
     */
    private String functionName;

    /**
     * 功能类型
     */
    private String functionType;

    /**
     * 功能状态
     */
    private Integer functionStatus;

    /**
     * 客户端类型
     */
    private String clientType;

    /**
     * 业务对象主键
     */
    private Long objectId;

    /**
     * 父功能编码
     */
    private String parentFunctionCode;

    /**
     * 外部引用业务对象编码
     */
    List<String> referDomainCodes;

}
