package com.elitesland.tw.tw5.api.prd.system.service;

import com.elitesland.tw.tw5.api.prd.system.payload.PrdSystemHelpPayload;
import com.elitesland.tw.tw5.api.prd.system.query.PrdSystemHelpQuery;
import com.elitesland.tw.tw5.api.prd.system.vo.PrdSystemHelpVO;
import com.elitescloud.cloudt.common.base.PagingVO;

import java.util.List;

public interface PrdSystemHelpService {
    /**
     * 新增
     *
     * @param payload 单条数据
     */
    PrdSystemHelpVO insert(PrdSystemHelpPayload payload);

    /**
     * 修改
     *
     * @param payload 单条数据
     */
    PrdSystemHelpVO update(PrdSystemHelpPayload payload);

    /**
     * 维度逻辑删除
     *
     * @param key 主键数组
     */
    void deleteSoft(Long ...key);

    /**
     * 通过主键查询
     * @param key 主键
     * @return vo对象
     */
    PrdSystemHelpVO queryByKey(Long key);

    /**
     * 分页查询
     * @param query 查询参数
     * @return 分页结果
     */
    PagingVO<PrdSystemHelpVO> paging(PrdSystemHelpQuery query);

    /**
     * 列表查询
     * @param query 查询参数
     * @return 分页结果
     */
    List<PrdSystemHelpVO> queryList(PrdSystemHelpQuery query);

}
