package com.elitesland.tw.tw5.api.prd.borrow.service;

import com.elitesland.tw.tw5.api.prd.borrow.payload.BorrowWriteOffPayload;
import com.elitesland.tw.tw5.api.prd.borrow.query.BorrowWriteOffQuery;
import com.elitesland.tw.tw5.api.prd.borrow.vo.BorrowWriteOffVO;
import com.elitescloud.cloudt.common.base.PagingVO;
import javax.servlet.http.HttpServletResponse;
import java.util.List;

/**
 * 借款核销
 *
 * @author wangly
 * @date 2024-07-15
 */
public interface BorrowWriteOffService {

    /**
     * 分页列表
     *
     * @param query 条件
     * @return {@link PagingVO}<{@link BorrowWriteOffVO}>
     */
    PagingVO<BorrowWriteOffVO> queryPaging(BorrowWriteOffQuery query);

    /**
     * 查询列表
     *
     * @param query 条件参数
     * @return {@link List}<{@link BorrowWriteOffVO}>
     */
    List<BorrowWriteOffVO> queryListDynamic(BorrowWriteOffQuery query);

    /**
     * 通过主键查询
     *
     * @param key 主键
     * @return {@link BorrowWriteOffVO}
     */
    BorrowWriteOffVO queryByKey(Long key);

    /**
     * 新增
     *
     * @param payload 单据数据
     * @return {@link BorrowWriteOffVO}
     */
    BorrowWriteOffVO insert(BorrowWriteOffPayload payload);

    /**
     * 修改
     *
     * @param payload 单据数据
     * @return {@link BorrowWriteOffVO}
     */
    BorrowWriteOffVO update(BorrowWriteOffPayload payload);

    /**
     * 修改,置空的字段需需要借助 protected List<String> nullFields;
     *
     * @param payload 单据数据
     * @return {@link long}
     */
    long updateByKeyDynamic(BorrowWriteOffPayload payload);

    /**
     * 逻辑删除
     *
     * @param keys 主键集合
     */
    void deleteSoft(List<Long> keys);

}
