package com.elitesland.tw.tw5.api.prd.borrow.vo;

import com.elitescloud.boot.common.param.BaseViewModel;
import com.elitesland.tw.tw5.api.udc.UdcName;
import io.swagger.annotations.ApiModelProperty;
import lombok.Getter;
import lombok.Setter;

import java.io.Serializable;
import java.time.LocalDate;
import java.math.BigDecimal;


/**
 * 借款核销
 *
 * @author wangly
 * @date 2024-07-15
 */
@Getter
@Setter
public class BorrowWriteOffVO extends BaseViewModel implements Serializable {
    /**
     * 借款ID
     */
    @ApiModelProperty("借款ID")
    private Long borrowId;
    /**
     * 核销关联单据ID
     */
    @ApiModelProperty("核销关联单据ID")
    private Long reimId;
    /**
     * 核销单据号
     */
    @ApiModelProperty("核销单据号")
    private String reimNo;
    /**
     * 核销类型 [BORROW_MONEY:WRITE_OFF_TYPE]
     */
    @ApiModelProperty("核销类型 [BORROW_MONEY:WRITE_OFF_TYPE]")
    private String writeOffType;
    /**
     * 核销类型 [BORROW_MONEY:WRITE_OFF_TYPE]
     */
    @ApiModelProperty("核销类型 [BORROW_MONEY:WRITE_OFF_TYPE]")
    @UdcName(udcName ="BORROW_MONEY:WRITE_OFF_TYPE",codePropName = "writeOffType")
    private String writeOffTypeDesc;
    /**
     * 核销单据名称
     */
    @ApiModelProperty("核销单据名称")
    private String writeOffName;
    /**
     * 核销人ID
     */
    @ApiModelProperty("核销人ID")
    private Long writeOffUserId;
    /**
     * 核销日期
     */
    @ApiModelProperty("核销日期")
    private LocalDate writeOffDate;
    /**
     * 核销金额
     */
    @ApiModelProperty("核销金额")
    private BigDecimal writeOffAmt;
    /**
     * 扩展字段1
     */
    @ApiModelProperty("扩展字段1")
    private String ext1;
    /**
     * 扩展字段2
     */
    @ApiModelProperty("扩展字段2")
    private String ext2;
    /**
     * 扩展字段3
     */
    @ApiModelProperty("扩展字段3")
    private String ext3;
    /**
     * 扩展字4
     */
    @ApiModelProperty("扩展字4")
    private String ext4;
    /**
     * 扩展字5
     */
    @ApiModelProperty("扩展字5")
    private String ext5;
}
