package com.elitesland.tw.tw5.api.prd.humanresources.service;

import java.util.List;

import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.tw.tw5.api.prd.humanresources.payload.PrdEvaluateConfigPointPayload;
import com.elitesland.tw.tw5.api.prd.humanresources.query.PrdEvaluateConfigPointQuery;
import com.elitesland.tw.tw5.api.prd.humanresources.vo.PrdEvaluateConfigPointVO;

import javax.servlet.http.HttpServletResponse;


/**
 * @author : WWW
 * @date : 2023-11-24
 * @desc : 评价配置点表Service
 */

public interface PrdEvaluateConfigPointService {

    /**
     * 新增评价配置点表数据
     *
     * @param prdEvaluateConfigPointPayload
     * @return
     */
    PrdEvaluateConfigPointVO save(PrdEvaluateConfigPointPayload prdEvaluateConfigPointPayload);

    /**
     * 根据主键更新
     *
     * @param prdEvaluateConfigPointPayload
     * @return
     */
    PrdEvaluateConfigPointVO update(PrdEvaluateConfigPointPayload prdEvaluateConfigPointPayload);

    /**
     * 根据主键获取详情
     *
     * @param id
     * @return
     */
    PrdEvaluateConfigPointVO get(Long id);

    /**
     * 分页查询列表
     *
     * @param prdEvaluateConfigPointQuery
     * @return
     */
    PagingVO<PrdEvaluateConfigPointVO> page(PrdEvaluateConfigPointQuery prdEvaluateConfigPointQuery);

    /**
     * 根据主键批量删除
     *
     * @param ids
     * @return
     */
    Long del(List<Long> ids);

    /**
     * 获取列表查询
     *
     * @param prdEvaluateConfigPointQuery
     * @return
     */
    List<PrdEvaluateConfigPointVO> getList(PrdEvaluateConfigPointQuery prdEvaluateConfigPointQuery);

    /**
     * 根据条件修改
     *
     * @param prdEvaluateConfigPointPayload
     * @return
     */
    Long updateByCondition(PrdEvaluateConfigPointPayload prdEvaluateConfigPointPayload);

}

