package com.elitesland.tw.tw5.api.prd.org.payload;

import com.elitesland.tw.tw5.api.common.TwCommonPayload;
import com.elitesland.workflow.enums.ProcInstStatus;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.time.LocalDate;
import java.time.LocalDateTime;

@Data
public class PrdOrgPersonPayload extends TwCommonPayload {

    @ApiModelProperty("姓名")
    private String personName;

    @ApiModelProperty("性别")
    private String sex;

    @ApiModelProperty("手机号")
    private String mobile;

    @ApiModelProperty(value = "用户邮箱地址")
    private String email;

    @ApiModelProperty("外文名")
    private String foreignName;

    @ApiModelProperty("证件类型")
    private String idType;

    @ApiModelProperty("证件号码")
    private String idNo;

    @ApiModelProperty("证件开始日")
    private LocalDate idValidFrom;

    @ApiModelProperty("证件到期日")
    private LocalDate idValidTo;

    @ApiModelProperty("证件url")
    private String idValidCodes;

    @ApiModelProperty("头像url")
    private String headCodes;

    @ApiModelProperty("生日")
    private LocalDate birthday;

    @ApiModelProperty("国籍")
    private String nationality;

    @ApiModelProperty("籍贯")
    private String birthplace;

    @ApiModelProperty("民族")
    private String nation;

    @ApiModelProperty("婚姻状况")
    private Integer marital;

    @ApiModelProperty("通讯地址")
    private String addr;

    @ApiModelProperty("紧急联系人")
    private String urgency_name;

    @ApiModelProperty("手机号")
    private String urgency_mobile;

    @ApiModelProperty("关系")
    private String urgency_ref;

    @ApiModelProperty("排序")
    private Integer sortIndex;

    @ApiModelProperty("自我评价")
    private String selfEvaluation;

    @ApiModelProperty("个人简历url")
    private String resumeCodes;

    @ApiModelProperty("自我介绍视频url")
    private String selfIntroVideoCodes;

    @ApiModelProperty("标签")
    private String selfTagging;

    @ApiModelProperty("专业技能&专业领域")
    private String professionalSkills;

    @ApiModelProperty("从业年限")
    private String professionalYears;

    @ApiModelProperty("流程实例ID")
    private String procInstId;

    @ApiModelProperty("流程审批状态")
    private ProcInstStatus procInstStatus;

    @ApiModelProperty("提交时间")
    private LocalDateTime submitTime;

    @ApiModelProperty("审批时间")
    private LocalDateTime approvedTime;
}
