package com.elitesland.tw.tw5.api.prd.pms.payload;

import com.elitesland.tw.tw5.api.common.TwCommonPayload;
import io.swagger.annotations.ApiModelProperty;
import lombok.Getter;
import lombok.Setter;

import java.io.Serializable;
import java.math.BigDecimal;
import java.time.LocalDate;

/**
 * 项目成员
 *
 * @author xxb
 * @date 2023-08-10
 */
@Getter
@Setter
public class PmsProjectMembersPayload extends TwCommonPayload implements Serializable {
    /**
     * 项目ID
     */
    @ApiModelProperty("项目ID")
    private Long projId;
    /**
     * 角色
     */
    @ApiModelProperty("角色")
    private String role;
    /**
     * 复合能力ID
     */
    @ApiModelProperty("复合能力ID")
    private Long capasetLevelId;
    /**
     * 资源id
     */
    @ApiModelProperty("资源id")
    private Long resId;
    /**
     * 预计开始日期
     */
    @ApiModelProperty("预计开始日期")
    private LocalDate planStartDate;
    /**
     * 预计结束日期
     */
    @ApiModelProperty("预计结束日期")
    private LocalDate planEndDate;
    /**
     * 规划当量
     */
    @ApiModelProperty("规划当量")
    private BigDecimal planEqva;
    /**
     * 工作台默认显示
     */
    @ApiModelProperty("工作台默认显示")
    private Integer workbenchFlag;
    /**
     * 客户结算价
     */
    @ApiModelProperty("客户结算价")
    private BigDecimal customerPrice;
//
//    @ApiModelProperty("任务包ID")
//    private Long taskPackageId;
}
