package com.elitesland.tw.tw5.api.prd.shorturl.query;

import com.elitesland.tw.tw5.api.common.TwQueryParam;
import io.swagger.annotations.ApiModelProperty;
import lombok.Getter;
import lombok.Setter;

import java.io.Serializable;

/**
 * 短链服务关系表
 *
 * @author duwh
 * @date 2023-05-19
 */
@Getter
@Setter
public class ShortUrlRefQuery extends TwQueryParam implements Serializable{
    /** 记录唯一ID 精确 */
    @ApiModelProperty("记录唯一ID")
    private Long id;
    /** 短链地址 精确 */
    @ApiModelProperty("短链地址")
    private String shortUrl;
    /** 短链地址-相对地址 */
    @ApiModelProperty("短链地址-相对地址")
    private String shortUrlRelative;
    /** 短链地址识别码 */
    @ApiModelProperty("短链地址识别码")
    private String code;
    /** 长链地址 精确 */
    @ApiModelProperty("长链地址")
    private String longUrl;
    /** 访问数量 精确 */
    @ApiModelProperty("访问数量")
    private Integer visitNum;
    /** 拓展1 精确 */
    @ApiModelProperty("拓展1")
    private String ext1;
    /** 拓展2 精确 */
    @ApiModelProperty("拓展2")
    private String ext2;
    /** 拓展3 精确 */
    @ApiModelProperty("拓展3")
    private String ext3;
    /** 拓展4 精确 */
    @ApiModelProperty("拓展4")
    private String ext4;
    /** 拓展5 精确 */
    @ApiModelProperty("拓展5")
    private String ext5;
}
