package com.elitesland.tw.tw5.api.common.funConfig.service;

import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.tw.tw5.api.common.funConfig.payload.BusinessDocTypeConfigPayload;
import com.elitesland.tw.tw5.api.common.funConfig.query.BusinessDocTypeConfigQuery;
import com.elitesland.tw.tw5.api.common.funConfig.vo.BusinessDocTypeConfigVO;
import com.elitesland.tw.tw5.api.common.funConfig.vo.BusinessDocTypePermissionPrevRecordVO;

import java.util.List;

/**
 * 易稻壳yeedoc通用文档类型配置表
 *
 * @author duwh
 * @date 2023-12-07
 */
public interface BusinessDocTypeConfigService {

    /**
     * 分页列表
     *
     * @param query 条件
     * @return {@link PagingVO}<{@link BusinessDocTypeConfigVO}>
     */
    PagingVO<BusinessDocTypeConfigVO> queryPaging(BusinessDocTypeConfigQuery query);

    /**
     * 查询列表
     *
     * @param query 条件参数
     * @return {@link List}<{@link BusinessDocTypeConfigVO}>
     */
    List<BusinessDocTypeConfigVO> queryListDynamic(BusinessDocTypeConfigQuery query);

    Long count(BusinessDocTypeConfigQuery query);

    /**
     * 通过主键查询
     *
     * @param key 主键
     * @return {@link BusinessDocTypeConfigVO}
     */
    BusinessDocTypeConfigVO queryByKey(Long key);

    /**
     * 新增
     *
     * @param payload 单据数据
     * @return {@link BusinessDocTypeConfigVO}
     */
    BusinessDocTypeConfigVO insert(BusinessDocTypeConfigPayload payload);

    /**
     * 修改
     *
     * @param payload 单据数据
     * @return {@link BusinessDocTypeConfigVO}
     */
    BusinessDocTypeConfigVO update(BusinessDocTypeConfigPayload payload);

    /**
     * 修改,置空的字段需需要借助 protected List<String> nullFields;
     *
     * @param payload 单据数据
     * @return {@link long}
     */
    long updateByKeyDynamic(BusinessDocTypeConfigPayload payload);

    /**
     * 逻辑删除
     *
     * @param keys 主键集合
     */
    void deleteSoft(List<Long> keys);

    /**
     * 获取yeeedoc信息
     *
     * @param docId            文档id
     * @param docType          单据类型
     * @param configId         配置id
     * @param createFolderName 创建文件夹名称
     * @return {@link BusinessDocTypePermissionPrevRecordVO}
     */
    BusinessDocTypePermissionPrevRecordVO getYeeedocInfo(Long docId, String docType, Long configId, String createFolderName);

    /**
     * 获取yeeedoc信息
     *
     * @param systemAdmin      系统管理员
     * @param userId           用户id
     * @param orgId            组织id
     * @param roleList         角色列表
     * @param docId            文档id
     * @param docType          单据类型
     * @param configId         配置id
     * @param createFolderName 创建文件夹名称
     * @return {@link BusinessDocTypePermissionPrevRecordVO}
     */
    BusinessDocTypePermissionPrevRecordVO getYeeedocInfo(boolean systemAdmin, Long userId, Long orgId, List<String> roleList, Long docId, String docType, Long configId, String createFolderName);

}
