package com.elitesland.tw.tw5.api.prd.adm.service;

import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.tw.tw5.api.prd.adm.payload.AdmFeeApplyPayload;
import com.elitesland.tw.tw5.api.prd.adm.query.AdmFeeApplyQuery;
import com.elitesland.tw.tw5.api.prd.adm.vo.AdmFeeApplyVO;
import com.elitesland.workflow.payload.ProcessStatusChangePayload;

import java.util.List;

/**
 * 特殊费用申请管理
 *
 * @author carl
 * @date 2023-11-01
 */
public interface AdmFeeApplyService {

    /**
     * 分页列表
     *
     * @param query 条件
     * @return {@link PagingVO}<{@link AdmFeeApplyVO}>
     */
    PagingVO<AdmFeeApplyVO> queryPaging(AdmFeeApplyQuery query);

    /**
     * 查询列表
     *
     * @param query 条件参数
     * @return {@link List}<{@link AdmFeeApplyVO}>
     */
    List<AdmFeeApplyVO> queryListDynamic(AdmFeeApplyQuery query);

    /**
     * 通过主键查询
     *
     * @param key 主键
     * @return {@link AdmFeeApplyVO}
     */
    AdmFeeApplyVO queryByKey(Long key);

    /**
     * 新增
     *
     * @param payload 单据数据
     * @return {@link AdmFeeApplyVO}
     */
    AdmFeeApplyVO insertOrUpdate(AdmFeeApplyPayload payload);

    //    /**
//     * 修改
//     *
//     * @param payload 单据数据
//     * @return {@link AdmFeeApplyVO}
//     */
//    AdmFeeApplyVO update(AdmFeeApplyPayload payload);
//
//    /**
//     * 修改,置空的字段需需要借助 protected List<String> nullFields;
//     *
//     * @param payload 单据数据
//     * @return {@link long}
//     */
    long updateByKeyDynamic(AdmFeeApplyPayload payload);

    /**
     * 逻辑删除
     *
     * @param keys 主键集合
     */
    void deleteSoft(List<Long> keys);

    /**
     * 流程回调
     *
     * @param payload
     */
    void processStatusChange(ProcessStatusChangePayload payload);

    /**
     * 根据注解获取(仅查询
     *
     * @param key
     * @return
     */
    AdmFeeApplyVO queryOneByKey(Long key);

    /**
     *
     * @param reimId
     */
    void unbindReim(Long reimId);
}
