package com.elitesland.tw.tw5.api.prd.app.service;

import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.tw.tw5.api.prd.app.payload.AppVersionPayload;
import com.elitesland.tw.tw5.api.prd.app.query.AppVersionQuery;
import com.elitesland.tw.tw5.api.prd.app.vo.AppVersionVO;

import java.util.List;

/**
* APP版本管理
*
* @author duwh
* @date 2023-02-23
*/
public interface AppVersionService {

    /**
    * 分页列表
    *
    * @param query 条件
    * @return {@link PagingVO}<{@link AppVersionVO}>
    */
    PagingVO<AppVersionVO> paging(AppVersionQuery query);

    /**
     * 查询列表
    *
    * @param query 条件参数
    * @return {@link List}<{@link AppVersionVO}>
    */
    List<AppVersionVO> queryList(AppVersionQuery query);

    /**
     * 通过主键查询
     *
     * @param key 主键
     * @return {@link AppVersionVO}
     */
    AppVersionVO queryByKey(Long key);

    /**
    * 新增
    *
    * @param payload 单据数据
    * @return {@link AppVersionVO}
    */
    AppVersionVO insert(AppVersionPayload payload);

    /**
    * 修改
    *
    * @param payload 单据数据
    * @return {@link AppVersionVO}
    */
    AppVersionVO update(AppVersionPayload payload);

    /**
    * 逻辑删除
    *
    * @param keys 主键集合
    */
    void deleteSoft(List<Long> keys);

    /**
     * 获得当前版本
     *
     * @return {@link AppVersionVO}
     */
    AppVersionVO getCurrentVersion();
}
