package com.elitesland.tw.tw5.api.prd.budget.payload;

import com.elitesland.tw.tw5.api.common.TwCommonPayload;
import io.swagger.annotations.ApiModelProperty;
import lombok.Getter;
import lombok.Setter;

import java.io.Serializable;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.util.List;

/**
 * 预算拨付基本信息
 *
 * @author xxb
 * @date 2023-11-01
 */
@Getter
@Setter
public class BudgetAppropriationPayload extends TwCommonPayload implements Serializable {
    /**
     * 预算ID
     */
    @ApiModelProperty("预算ID")
    private Long budgetId;
    /**
     * 拨付单号
     */
    @ApiModelProperty("拨付单号")
    private String appropriationNo;
    /**
     * 拨付状态
     */
    @ApiModelProperty("拨付状态")
    private String appropriationStatus;
    /**
     * 申请人资源ID
     */
    @ApiModelProperty("申请人资源ID")
    private Long resId;
    /**
     * 申请费用金额
     */
    @ApiModelProperty("申请费用金额")
    private BigDecimal applyFeeAmt;
    /**
     * 申请拨付当量数
     */
    @ApiModelProperty("申请拨付当量数")
    private BigDecimal applyEqva;
    /**
     * 申请拨付当量金额
     */
    @ApiModelProperty("申请拨付当量金额")
    private BigDecimal applyEqvaAmt;
    /**
     * 申请总金额
     */
    @ApiModelProperty("申请总金额")
    private BigDecimal applyAmt;
//    /**
//     * 拨付金额
//     */
//    @ApiModelProperty("拨付金额")
//    private BigDecimal amt;
    /**
     * 申请日期
     */
    @ApiModelProperty("申请日期")
    private LocalDate applyDate;
    /**
     * 流程实例ID
     */
    @ApiModelProperty("流程实例ID")
    private String procInstId;
    /**
     * 流程审批状态
     */
    @ApiModelProperty("流程审批状态")
    private Integer procInstStatus;
    /**
     * 审批时间
     */
    @ApiModelProperty("审批时间")
    private LocalDateTime approvedTime;
    /**
     * 拨款名称
     */
    @ApiModelProperty("拨款名称")
    private String appropriationName;
    /**
     * 拨款日期
     */
    @ApiModelProperty("拨款日期")
    private LocalDate appropriationDate;
    /**
     * 拨付附件
     */
    @ApiModelProperty("拨付附件")
    private String appropriationFiles;
    /**
     * 流程定义的KEY
     */
    @ApiModelProperty("流程定义的KEY")
    private String procDefKey;
    /**
     * 拨付类型：科目、活动
     */
    @ApiModelProperty("拨付类型：科目、活动")
    private String appropriationType;
    /**
     * 拨付当量
     */
    @ApiModelProperty("拨付当量")
    private BigDecimal allocateEqva;
    /**
     * 拨付费用
     */
    @ApiModelProperty("拨付费用")
    private BigDecimal allocateCost;
    /**
     * 当量预估单价
     */
    @ApiModelProperty("当量预估单价")
    private BigDecimal eqvaPrice;

    /**
     * 工作类型
     */
    private String workType;

    /**
     * 平台合同类型
     */
    private String platType;

    /**
     * 合同id
     */
    private Long contractId;

    /**
     * pmo资源负责人id
     */
    private Long pmoResId;

    /**
     * 交付BU_ID
     */
    private Long deliBuId;

    /**
     * 交付用户id
     */
    private Long deliUserId;

    /**
     * 项目名称
     */
    private String projName;

    /**
     * 预算拨付提交标志
     */
    @ApiModelProperty("预算拨付提交标志")
    private Boolean submitFlag = false;

    @ApiModelProperty("拨付明细")
    private List<BudgetAppropriationDetailPayload> appropriationDetailPayloads;
}
