package com.elitesland.tw.tw5.api.prd.budget.payload;

import com.elitesland.tw.tw5.api.common.TwCommonPayload;
import com.elitesland.tw.tw5.api.prd.budget.vo.PmsBudgetOccupyDocInfo;
import io.swagger.annotations.ApiModelProperty;
import lombok.Getter;
import lombok.Setter;

import java.io.Serializable;
import java.math.BigDecimal;
import java.time.LocalDateTime;

/**
 * 预算占用管理
 *
 * @author ben
 * @date 2023-12-05
 */
@Getter
@Setter
public class PmsBudgetOccupyPayload extends TwCommonPayload implements Serializable {
    /** 单据id */
    @ApiModelProperty("单据id")
    private Long docId;
    /** 费用类型：当量｜费用 */
    @ApiModelProperty("费用类型：当量｜费用")
    private String costType;
    /** 来源类型：任务｜报销 */
    @ApiModelProperty("来源类型：任务｜报销")
    private String docType;
    /** 单据编号 */
    @ApiModelProperty("单据编号")
    private String docCode;
    /** 单据名称 */
    @ApiModelProperty("单据名称")
    private String docName;
    /** 预算id */
    @ApiModelProperty("预算id")
    private Long budgetId;
    /** 归属资源（当量预算|费用预算）id */
    @ApiModelProperty("归属资源（当量预算|费用预算）id")
    private Long belongToId;
    /** 占用数 */
    @ApiModelProperty("占用数")
    private BigDecimal occupyAmt;
    /** 已使用数 */
    @ApiModelProperty("已使用数")
    private BigDecimal usedAmt;
    /** 单据日期 */
    @ApiModelProperty("单据日期")
    private LocalDateTime docTime;
    /** 业务对象 */
    private PmsBudgetOccupyDocInfo docInfo;
}
