package com.elitesland.tw.tw5.api.prd.budget.query;

import com.elitesland.tw.tw5.api.common.TwQueryParam;
import io.swagger.annotations.ApiModelProperty;
import lombok.Getter;
import lombok.Setter;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.List;

/**
 * 预算拨付明细
 *
 * @author xxb
 * @date 2023-11-01
 */
@Getter
@Setter
public class BudgetAppropriationDetailQuery extends TwQueryParam implements Serializable{
    /** 记录唯一ID 精确 */
    @ApiModelProperty("记录唯一ID")
    private Long id;
    /** 拨款ID 精确 */
    @ApiModelProperty("拨款ID")
    private Long appropriationId;
    /** 拨款金额 精确 */
    @ApiModelProperty("拨款金额")
    private BigDecimal allocateCost;
    /** 活动id 精确 */
    @ApiModelProperty("活动id")
    private Long activityId;
    /** 拨付当量 精确 */
    @ApiModelProperty("拨付当量")
    private BigDecimal allocateEqva;
    /** 预算科目明细ID 精确 */
    @ApiModelProperty("预算科目明细ID")
    private Long budgetSubjectDetailId;
    /** 可配置字段1 精确 */
    @ApiModelProperty("可配置字段1")
    private String configurableField1;
    /** 可配置字段2 精确 */
    @ApiModelProperty("可配置字段2")
    private String configurableField2;
    /** 可配置字段3 精确 */
    @ApiModelProperty("可配置字段3")
    private String configurableField3;
}
