package com.elitesland.tw.tw5.api.prd.budget.service;


import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.tw.tw5.api.prd.budget.payload.BudgetAppropriationPayload;
import com.elitesland.tw.tw5.api.prd.budget.query.BudgetAppropriationQuery;
import com.elitesland.tw.tw5.api.prd.budget.vo.BudgetAppropriationVO;
import com.elitesland.tw.tw5.api.prd.budget.vo.BudgetVO;
import com.elitesland.workflow.payload.ProcessStatusChangePayload;

import java.util.List;

/**
 * 预算拨付基本信息
 *
 * @author xxb
 * @date 2023-11-01
 */
public interface BudgetAppropriationService {

    /**
     * 分页列表
     *
     * @param query 条件
     * @return {@link PagingVO}<{@link BudgetAppropriationVO}>
     */
    PagingVO<BudgetAppropriationVO> queryPaging(BudgetAppropriationQuery query);

    /**
     * 查询列表
     *
     * @param query 条件参数
     * @return {@link List}<{@link BudgetAppropriationVO}>
     */
    List<BudgetAppropriationVO> queryListDynamic(BudgetAppropriationQuery query);

    /**
     * 通过主键查询
     *
     * @param key 主键
     * @return {@link BudgetAppropriationVO}
     */
    BudgetAppropriationVO queryByKey(Long key);

    /**
     * 新增
     *
     * @param payload 单据数据
     * @return {@link BudgetAppropriationVO}
     */
    void save(BudgetAppropriationPayload payload);


    /**
     * 首次预算提交时 的预算拨付保存
     *
     * @param payload
     */
    void saveBudgetAppropriation(BudgetAppropriationPayload payload);


    /**
     * 拨付信息 验证
     *
     * @param payload
     */
    void checkAppropriation(BudgetAppropriationPayload payload, BudgetVO budgetVO);

    /**
     * 流程回调
     *
     * @param payload
     */
    void processStatusChange(ProcessStatusChangePayload payload);

}
