package com.elitesland.tw.tw5.api.prd.budget.service;

import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.tw.tw5.api.prd.budget.payload.PmsBudgetOccupyPayload;
import com.elitesland.tw.tw5.api.prd.budget.query.PmsBudgetOccupyQuery;
import com.elitesland.tw.tw5.api.prd.budget.vo.PmsBudgetOccupyVO;

import java.util.List;

/**
 * 预算占用管理
 *
 * @author ben
 * @date 2023-12-05
 */
public interface PmsBudgetOccupyService {

    /**
     * 分页列表
     *
     * @param query 条件
     * @return {@link PagingVO}<{@link PmsBudgetOccupyVO}>
     */
    PagingVO<PmsBudgetOccupyVO> queryPaging(PmsBudgetOccupyQuery query);

    /**
     * 查询列表
     *
     * @param query 条件参数
     * @return {@link List}<{@link PmsBudgetOccupyVO}>
     */
    List<PmsBudgetOccupyVO> queryListDynamic(PmsBudgetOccupyQuery query);

    /**
     * 通过主键查询
     *
     * @param key 主键
     * @return {@link PmsBudgetOccupyVO}
     */
    PmsBudgetOccupyVO queryByKey(Long key);

    /**
     * 新增
     *
     * @param payload 单据数据
     * @return {@link PmsBudgetOccupyVO}
     */
    PmsBudgetOccupyVO insert(PmsBudgetOccupyPayload payload);

    /**
     * 修改
     *
     * @param payload 单据数据
     * @return {@link PmsBudgetOccupyVO}
     */
    PmsBudgetOccupyVO update(PmsBudgetOccupyPayload payload);

    /**
     * 修改,置空的字段需需要借助 protected List<String> nullFields;
     *
     * @param payload 单据数据
     * @return {@link long}
     */
    long updateByKeyDynamic(PmsBudgetOccupyPayload payload);

    /**
     * 逻辑删除
     *
     * @param keys 主键集合
     */
    void deleteSoft(List<Long> keys);

    /**
     * 新增修改
     *
     * @param payload 单据数据
     * @return long
     */
    long saveOrUpdate(List<PmsBudgetOccupyPayload> payload);

    /**
     * 取消
     *
     * @param payload 单据数据
     * @return long
     */
    long cancel(List<PmsBudgetOccupyPayload> payload);

}
