package com.elitesland.tw.tw5.api.prd.budget.vo;

import com.elitescloud.boot.common.param.BaseViewModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Getter;
import lombok.Setter;

import java.io.Serializable;
import java.math.BigDecimal;


/**
 * 预算拨付明细
 *
 * @author xxb
 * @date 2023-11-01
 */
@Getter
@Setter
public class BudgetAppropriationDetailVO extends BaseViewModel implements Serializable {
    /**
     * 拨款ID
     */
    @ApiModelProperty("拨款ID")
    private Long appropriationId;
    /**
     * 拨款金额
     */
    @ApiModelProperty("拨款金额")
    private BigDecimal allocateCost;
    /**
     * 活动id
     */
    @ApiModelProperty("活动id")
    private Long activityId;
    /**
     * 拨付当量
     */
    @ApiModelProperty("拨付当量")
    private BigDecimal allocateEqva;
    /**
     * 预算科目明细ID
     */
    @ApiModelProperty("预算科目明细ID")
    private Long budgetSubjectDetailId;
    /**
     * 可配置字段1
     */
    @ApiModelProperty("可配置字段1")
    private String configurableField1;
    /**
     * 可配置字段2
     */
    @ApiModelProperty("可配置字段2")
    private String configurableField2;
    /**
     * 可配置字段3
     */
    @ApiModelProperty("可配置字段3")
    private String configurableField3;
}
